package it.openutils.web.spring;

import it.openutils.web.util.MessageUtils;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.mvc.Controller;


/**
 * @author fgiust
 * @version $Revision$ ($Author$)
 */
public abstract class SimpleController extends WebApplicationObjectSupport implements Controller
{

    /**
     * Logger.
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * Jsp name.
     */
    protected String successView;

    /**
     * Getter for <code>successView</code>.
     * @return Returns the successView.
     */
    public String getSuccessView()
    {
        return this.successView;
    }

    /**
     * Setter for <code>successView</code>.
     * @param successView The successView to set.
     */
    public void setSuccessView(String successView)
    {
        this.successView = successView;
    }

    // /**
    // * Convenience method for getting a i18n key's value. Calling getMessageSourceAccessor() is used because the
    // * RequestContext variable is not set in unit tests b/c there's no DispatchServlet Request.
    // * @param msgKey
    // * @return String
    // */
    // public String getText(String msgKey)
    // {
    // String currentLocale = ThreadLocaleHolder.getLocale();
    // if (currentLocale != null)
    // {
    // return getMessageSourceAccessor().getMessage(msgKey, new Locale(currentLocale));
    // }
    //
    // return getMessageSourceAccessor().getMessage(msgKey);
    // }

    /**
     * Convenient method for getting a i18n key's value with a single string argument.
     * @param msgKey
     * @param arg
     * @return String
     */
    public String getText(String msgKey, Object arg)
    {
        return getText(msgKey, new Object[]{arg});
    }

    public void saveMessage(HttpServletRequest request, String message)
    {
        MessageUtils.saveMessage(request, message);
    }

    public void saveError(HttpServletRequest request, String message)
    {
        MessageUtils.saveError(request, message);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString()
    {
        return ClassUtils.getShortClassName(getClass());
    }

}