package it.openutils.web.spring;

import it.openutils.web.util.MessageUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;


/**
 * @author fgiust
 * @version $Revision$ ($Author$)
 */
public abstract class MultiController extends MultiActionController implements Controller
{

    /**
     * Logger.
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * Jsp name.
     */
    protected String successView;

    /**
     * Setter for <code>successView</code>.
     * @param successView The successView to set.
     */
    public void setSuccessView(String successView)
    {
        this.successView = successView;
    }

    /**
     * Convenience method for getting a i18n key's value. Calling getMessageSourceAccessor() is used because the
     * RequestContext variable is not set in unit tests b/c there's no DispatchServlet Request.
     * @param msgKey
     * @return String
     */
    public String getText(String msgKey)
    {
        return getMessageSourceAccessor().getMessage(msgKey);
    }

    /**
     * Convenient method for getting a i18n key's value with a single string argument.
     * @param msgKey
     * @param arg
     * @return String
     */
    public String getText(String msgKey, Object arg)
    {
        return getText(msgKey, new Object[]{arg });
    }

    /**
     * Convenience method for getting a i18n key's value with arguments.
     * @param msgKey
     * @param args
     * @return String
     */
    public String getText(String msgKey, Object[] args)
    {
        return getMessageSourceAccessor().getMessage(msgKey, args);
    }

    public void saveMessage(HttpServletRequest request, String message)
    {
        MessageUtils.saveMessage(request, message);
    }

    public void saveError(HttpServletRequest request, String message)
    {
        MessageUtils.saveError(request, message);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response)
        throws Exception
    {
        log.debug("handleRequestInternal");
        try
        {
            String methodName = this.getMethodNameResolver().getHandlerMethodName(request);
            log.debug("methodName is " + methodName);
            return invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex)
        {
            pageNotFoundLogger.warn(ex.getMessage());
            response.sendError(HttpServletResponse.SC_NOT_FOUND);
            return null;
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString()
    {
        return ClassUtils.getShortClassName(getClass());
    }

}