package it.openutils.web.spring;

import java.text.NumberFormat;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.propertyeditors.CustomNumberEditor;


/**
 * Convenience double custom editor which allows to use both "." and "," as decimal separators.
 * @author fgiust
 * @version $Revision$ ($Author$)
 */
public class EasyDoubleCustomEditor extends CustomNumberEditor
{

    /**
     * @param numberClass
     * @param allowEmpty
     * @throws IllegalArgumentException
     */
    public EasyDoubleCustomEditor(Class< ? extends Number> numberClass, boolean allowEmpty)
        throws IllegalArgumentException
    {
        super(numberClass, allowEmpty);
    }

    /**
     * @param numberClass
     * @param numberFormat
     * @param allowEmpty
     * @throws IllegalArgumentException
     */
    public EasyDoubleCustomEditor(Class< ? extends Number> numberClass, NumberFormat numberFormat, boolean allowEmpty)
        throws IllegalArgumentException
    {
        super(numberClass, numberFormat, allowEmpty);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException
    {
        super.setAsText(StringUtils.replace(text, ",", "."));
    }

}
