package it.openutils.web.spring;

import it.openutils.web.util.MessageUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.SimpleFormController;


/**
 * @author fgiust
 * @version $Revision$ ($Author$)
 */
public class BaseFormController extends SimpleFormController
{

    /**
     * Logger.
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * {@inheritDoc}
     */
    @Override
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder)
    {
        // convert java.util.Date
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, null, new CustomDateEditor(dateFormat, true, 10));

        // convert Integers and Longs
        binder.registerCustomEditor(Long.class, null, new CustomNumberEditor(Long.class, true));
        binder.registerCustomEditor(Double.class, null, new EasyDoubleCustomEditor(Double.class, true));
        binder.registerCustomEditor(Integer.class, null, new CustomNumberEditor(Integer.class, true));
        binder.registerCustomEditor(Short.class, null, new CustomNumberEditor(Short.class, true));

        // trim empty strings
        binder.registerCustomEditor(String.class, new StringTrimmerEditor(true));

    }

    /**
     * Convenient method for getting a i18n key's value with a single string argument.
     * @param msgKey
     * @param arg
     * @return String
     */
    public String getText(String msgKey, Object arg)
    {
        return getText(msgKey, new Object[]{arg });
    }

    public void saveMessage(HttpServletRequest request, String message)
    {
        MessageUtils.saveMessage(request, message);
    }

    public void saveError(HttpServletRequest request, String message)
    {
        MessageUtils.saveError(request, message);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString()
    {
        return ClassUtils.getShortClassName(getClass());
    }

}