package it.openutils.spring.validation.hibernate;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;


/**
 * @author fgiust
 * @version $Id: AnnotationValidator.java 269 2007-02-17 14:39:26Z fgiust $
 */
public class AnnotationValidator implements Validator, ApplicationContextAware
{

    /**
     * ApplicationContext needed for message resolution.
     */
    private ApplicationContext applicationContext;

    /**
     * Sets the applicationContext.
     * @param applicationContext the applicationContext to set
     */
    public void setApplicationContext(ApplicationContext applicationContext)
    {
        this.applicationContext = applicationContext;
    }

    /**
     * @see org.springframework.validation.Validator#supports(java.lang.Class)
     */
    @SuppressWarnings("unchecked")
    public boolean supports(Class clazz)
    {
        return true;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public void validate(Object obj, Errors errors)
    {
        ClassValidator classValidator = new ClassValidator(obj.getClass(), new KeybackResourceBundle());

        InvalidValue[] validationMessages = classValidator.getInvalidValues(obj);
        for (InvalidValue value : validationMessages)
        {
            String field = value.getPropertyPath();

            String[] codes = new String[]{errors.getObjectName() + Errors.NESTED_PATH_SEPARATOR + field, field };

            errors.rejectValue(
                field,
                value.getMessage(),
                new Object[]{new DefaultMessageSourceResolvable(codes, field) },
                null);

        }
    }

    /**
     * ResourceBundle implementation that always returns the same String used as a key. Needed to avoid making
     * ClassValidator resolve message keys, so that they will still be available to Spring.
     * @author fgiust
     * @version $Id: AnnotationValidator.java 269 2007-02-17 14:39:26Z fgiust $
     */
    protected static class KeybackResourceBundle extends ResourceBundle
    {

        /**
         * {@inheritDoc}
         */
        @Override
        public Enumeration<String> getKeys()
        {
            return new Hashtable<String, String>().keys();
        }

        /**
         * {@inheritDoc}
         */
        @Override
        protected Object handleGetObject(String key)
        {
            return key;
        }

    }

}
