package it.openutils.spring.editors;

import java.beans.PropertyEditorSupport;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fgiust
 * @version $Id: GenericSinglePropertyEditor.java 248 2007-02-13 10:23:46Z fgiust $
 */
public class GenericSinglePropertyEditor<T> extends PropertyEditorSupport
{

    /**
     * Logger.
     */
    private static Logger log = LoggerFactory.getLogger(GenericSinglePropertyEditor.class);

    /**
     * Generic data access object.
     */
    private Object dao;

    /**
     * property name in object
     */
    private String propertyName;

    /**
     * property type for object id
     */
    private Class<T> propertyType;

    /**
     * ProfiloPropertyEditor.
     * @param dao generic DAO
     * @param propertyName property name
     * @param propertyType property type
     */
    public GenericSinglePropertyEditor(Object dao, String propertyName, Class<T> propertyType)
    {
        this.dao = dao;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getAsText()
    {
        Object value = getValue();

        log.debug("getAsText({})", value);

        String returnString = null;

        if (value != null)
        {
            try
            {
                returnString = BeanUtils.getProperty(value, propertyName);
            }
            catch (Exception e)
            {
                log.error(e.getMessage(), e);
            }
        }

        return StringUtils.defaultString(returnString);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException
    {
        log.debug("setAsText({})", text);

        if (StringUtils.isNotBlank(text))
        {

            try
            {
                Object[] parameters = new Object[1];

                if (Integer.class.equals(this.propertyType))
                {
                    parameters[0] = new Integer(text);
                }
                if (String.class.equals(this.propertyType))
                {
                    parameters[0] = text;
                }
                if (Long.class.equals(this.propertyType))
                {
                    parameters[0] = new Long(text);
                }

                Object value = MethodUtils.invokeMethod(dao, "load", parameters, new Class[]{this.propertyType });
                setValue(value);
            }
            catch (Exception e)
            {
                log.error(e.getMessage(), e);
            }

        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setValue(Object value)
    {
        super.setValue(value);
    }
}
