package it.openutils.spring.editors;

import java.beans.PropertyEditorSupport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fgiust
 * @version $Id: GenericSetPropertyEditor.java 194 2007-02-02 09:48:16Z fcarone $
 */
public class GenericSetPropertyEditor<T> extends PropertyEditorSupport
{

    /**
     * Logger.
     */
    private static Logger log = LoggerFactory.getLogger(GenericSetPropertyEditor.class);

    /**
     * Generic data access object.
     */
    private Object dao;

    /**
     * property name in object
     */
    private String propertyName;

    /**
     * property type for object id
     */
    private Class<T> propertyType;

    /**
     * ProfiloPropertyEditor.
     * @param dao generic DAO
     * @param propertyName property name
     * @param propertyType property type
     */
    public GenericSetPropertyEditor(Object dao, String propertyName, Class<T> propertyType)
    {
        this.dao = dao;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    @Override
    public String getAsText()
    {
        Set<T> value = (Set<T>) getValue();

        log.debug("getAsText({})", value);

        if (value != null && value.size() > 0)
        {
            try
            {
                StringBuffer buffer = new StringBuffer();
                Iterator<T> iterator = value.iterator();
                while (iterator.hasNext())
                {
                    T item = iterator.next();

                    buffer.append(BeanUtils.getProperty(item, propertyName));
                    if (iterator.hasNext())
                    {
                        buffer.append(",");
                    }

                }

                return buffer.toString();
            }
            catch (Exception e)
            {
                log.error(e.getMessage(), e);
            }
        }

        return StringUtils.EMPTY;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    @Override
    public void setAsText(String text) throws IllegalArgumentException
    {

        log.debug("setAsText({})", text);

        if (StringUtils.isNotEmpty(text))
        {
            Set<T> set = new HashSet<T>();
            String[] values = StringUtils.split(text, ',');
            for (int j = 0; j < values.length; j++)
            {
                String id = values[j];
                if (StringUtils.isNotEmpty(id))
                {
                    try
                    {
                        Object[] parameters = new Object[1];

                        if (Integer.class.equals(this.propertyType))
                        {
                            parameters[0] = new Integer(id);
                        }
                        if (String.class.equals(this.propertyType))
                        {
                            parameters[0] = id;
                        }
                        if (Long.class.equals(this.propertyType))
                        {
                            parameters[0] = new Long(id);
                        }

                        T value = (T) MethodUtils.invokeMethod(dao, "load", parameters, new Class[]{this.propertyType});
                        set.add(value);
                    }
                    catch (Throwable e)
                    {
                        log.error("Not adding object with id [" + id + "] due to a " + e.getClass().getName(), e);
                    }
                }
            }
            setValue(set);
        }
    }
}
