package it.openutils.spring.context;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * Listener for Servlet 2.4+ containers. Exposes the web application context to the current thread, through
 * WebApplicationContextHolder. To be registered as listener in <code>web.xml</code>.
 * @author Fabrizio Giustina
 * @version $Id: WebApplicationContextListener.java 275 2007-02-19 17:13:52Z fgiust $
 */
public class WebApplicationContextListener implements ServletRequestListener
{

    /**
     * {@inheritDoc}
     */
    public void requestInitialized(ServletRequestEvent sre)
    {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sre.getServletContext());
        WebApplicationContextHolder.set(wac);
    }

    /**
     * {@inheritDoc}
     */
    public void requestDestroyed(ServletRequestEvent sre)
    {
        WebApplicationContextHolder.set(null);
    }

}
