package it.openutils.spring.context;

import org.springframework.web.context.WebApplicationContext;


/**
 * Holder class to expose the web application context in the form of a thread-bound {@link WebApplicationContext}
 * object.
 * <p>
 * Use {@link WebApplicationContextListener} to expose the current application context.
 * @author Fabrizio Giustina
 * @version $Id: WebApplicationContextHolder.java 275 2007-02-19 17:13:52Z fgiust $
 */
public final class WebApplicationContextHolder
{

    private static ThreadLocal<WebApplicationContext> tl = new ThreadLocal<WebApplicationContext>();

    /**
     * Don't instantiate.
     */
    private WebApplicationContextHolder()
    {
        // unused
    }

    /**
     * Returns the thread-bound WebApplicationContext.
     * @return WebApplicationContext
     */
    public static WebApplicationContext get()
    {
        return tl.get();
    }

    /**
     * Bind a WebApplicationContext to the current thread.
     * @param webApplicationContext WebApplicationContext
     */
    public static void set(WebApplicationContext webApplicationContext)
    {
        tl.set(webApplicationContext);
    }
}
