/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.spring;

import it.openutils.deployment.spring.EnvironmentPropertyConfigurer;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class DatabaseEnvironmentPropertyConfigurer
extends EnvironmentPropertyConfigurer
implements ApplicationContextAware,
ApplicationListener {
    private static Logger log = LoggerFactory.getLogger(DatabaseEnvironmentPropertyConfigurer.class);
    private String sqlQuery;
    private String dataSourceName;
    private DataSource dataSource;
    private ApplicationContext applicationContext;

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void loadAndRefresh() throws IOException {
        this.properties = this.mergeProperties();
        this.refresh();
    }

    public void refresh() {
        this.manuallyLoadDatasource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        try {
            class RowHandler
            implements RowCallbackHandler {
                RowHandler() {
                }

                public void processRow(ResultSet rs) throws SQLException {
                    String parmName = rs.getString(1);
                    String parmValue = rs.getString(2);
                    log.debug("Configuring property {}={}", (Object)parmName, (Object)parmValue);
                    DatabaseEnvironmentPropertyConfigurer.this.properties.put(parmName, parmValue);
                }
            }
            jdbcTemplate.query(this.sqlQuery, (RowCallbackHandler)new RowHandler());
        }
        catch (DataAccessException e) {
            log.error(e.getMessage());
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.manuallyLoadDatasource();
    }

    private void manuallyLoadDatasource() {
        if (this.dataSource == null) {
            this.dataSource = (DataSource)this.applicationContext.getBean(this.dataSourceName);
            try {
                this.properties = this.mergeProperties();
            }
            catch (IOException e) {
                log.debug("Exception while loading environment properties from file.");
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.postProcessBeanFactory(beanFactory);
        try {
            this.loadAndRefresh();
            Properties mergedProps = this.properties;
            this.convertProperties(mergedProps);
            this.processProperties(beanFactory, mergedProps);
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", (Throwable)ex);
        }
    }
}

