/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.log4j;

import it.openutils.deployment.log4j.DeploymentResolver;
import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.util.Log4jConfigurer;
import org.springframework.web.util.Log4jConfigListener;
import org.springframework.web.util.WebUtils;

public class EnvironmentLog4jConfigListener
extends Log4jConfigListener {
    public static final String DEFAULT_INITIALIZATION_PARAMETER = "WEB-INF/config/${servername}/${webapp}/log4j.xml,WEB-INF/config/${servername}/log4j.xml,WEB-INF/config/${webapp}/log4j.xml,WEB-INF/config/default/log4j.xml,WEB-INF/config/log4j.xml";

    public void contextInitialized(ServletContextEvent event) {
        EnvironmentLog4jConfigListener.initLogging(event.getServletContext());
    }

    public static void initLogging(ServletContext servletContext) {
        block11: {
            String location;
            String locationList;
            if (EnvironmentLog4jConfigListener.exposeWebAppRoot(servletContext)) {
                WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
                String servername = DeploymentResolver.resolveServerName();
                if (servername != null) {
                    System.setProperty("server.name", servername);
                    System.setProperty("server", servername);
                }
            }
            if ((locationList = servletContext.getInitParameter("log4jConfigLocation")) == null) {
                locationList = DEFAULT_INITIALIZATION_PARAMETER;
            }
            try {
                location = DeploymentResolver.resolveServerRelativeLocation(servletContext, locationList).getAbsolutePath();
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex.getMessage());
            }
            if (location != null) {
                servletContext.log("Initializing Log4J from [" + location + "]");
                try {
                    String intervalString = servletContext.getInitParameter("log4jRefreshInterval");
                    if (intervalString != null) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging((String)location, (long)refreshInterval);
                            break block11;
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + ex.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging((String)location);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex.getMessage());
                }
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter("log4jExposeWebAppRoot");
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

