/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.paging;

import it.openutils.hibernate.paging.PaginatedResult;
import it.openutils.hibernate.paging.PaginatedResultImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PaginatedResultUtils {
    static Logger log = LoggerFactory.getLogger(PaginatedResultUtils.class);

    public static <T> PaginatedResult<T> search(Criteria criteria, int pagesize, int pageNumberStartingFromOne) {
        if (pagesize > 0) {
            criteria.setMaxResults(pagesize);
        }
        if (pageNumberStartingFromOne > 1 && pagesize > 0) {
            int firstresult = (pageNumberStartingFromOne - 1) * pagesize;
            log.debug("Setting first result {}", (Object)firstresult);
            criteria.setFirstResult(firstresult);
        }
        List results = criteria.list();
        criteria.setFirstResult(0);
        Number count = (Number)criteria.setProjection((Projection)Projections.count((String)"id")).uniqueResult();
        if (count == null) {
            count = 0;
        }
        PaginatedResultImpl result = new PaginatedResultImpl(pagesize, pageNumberStartingFromOne, count.intValue());
        result.setResults(results);
        return result;
    }
}

