/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.paging;

import it.openutils.hibernate.paging.PaginatedResult;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedResultImpl<T>
implements PaginatedResult<T> {
    private final int itemsPerPage;
    private final int pageNumberStartingFromOne;
    private final int totalSize;
    private Collection<T> results;
    private static final long serialVersionUID = 42L;

    public PaginatedResultImpl(int itemsPerPage, int pageNumberStartingFromOne, int totalSize) {
        this.itemsPerPage = itemsPerPage;
        this.pageNumberStartingFromOne = pageNumberStartingFromOne;
        this.totalSize = totalSize;
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public int getPage() {
        return this.pageNumberStartingFromOne;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getNumberOfPages() {
        return this.itemsPerPage > 0 ? (int)Math.round(Math.ceil((float)this.totalSize / (float)this.itemsPerPage)) : 1;
    }

    @Override
    public Collection<T> getItems() {
        return this.results;
    }

    @Override
    public T getFirstResult() {
        if (this.results != null && this.results.size() > 0) {
            return this.results.iterator().next();
        }
        return null;
    }

    public void setResults(Collection<T> results) {
        this.results = results;
    }
}

