/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.example;

import it.openutils.hibernate.example.FilterMetadata;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMetadataSupport {
    private final Object entity;
    private Map<String, ? extends FilterMetadata> filterMetadata;

    public FilterMetadataSupport(Object entity, Map<String, ? extends FilterMetadata> filterMetadata) {
        if (entity == null) {
            throw new NullPointerException("Null entity.");
        }
        this.entity = entity;
        this.filterMetadata = filterMetadata;
    }

    public Criteria create(Session ses) {
        return this.appendTo(ses.createCriteria(Hibernate.getClass((Object)this.entity)), ses);
    }

    public Criteria appendTo(Criteria crit, Session ses) {
        return new ExampleTreeWalker(ses).walk(crit, this.entity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExampleTreeWalker {
        private final SessionFactory sessionFactory;
        private EntityMode entityMode;

        public ExampleTreeWalker(Session session) {
            this.sessionFactory = session.getSessionFactory();
            this.entityMode = session.getEntityMode();
        }

        public Criteria walk(Criteria rootCriteria, Object rootEntity) {
            this.createSubExamples(rootCriteria, rootEntity, new String[0]);
            return rootCriteria;
        }

        private void createSubExamples(Criteria crit, Object entity, String[] walkedProperties) {
            String path = this.getPath(walkedProperties);
            Map<String, FilterMetadata> currFilterMetadata = this.getFilterMetadata(path);
            crit.add((Criterion)this.example(entity, currFilterMetadata.keySet()));
            ClassMetadata classMetadata = this.sessionFactory.getClassMetadata(Hibernate.getClass((Object)entity));
            Type[] types = classMetadata.getPropertyTypes();
            String[] names = classMetadata.getPropertyNames();
            for (int i = 0; i < types.length; ++i) {
                String propertyName = names[i];
                if (this.alreadyWalked(walkedProperties, propertyName)) continue;
                Object propertyValue = classMetadata.getPropertyValue(entity, propertyName, this.entityMode);
                FilterMetadata fm = currFilterMetadata.get(propertyName);
                if (fm != null) {
                    fm.createFilter(crit, propertyName, propertyValue);
                    continue;
                }
                Type propertyType = types[i];
                if (!propertyType.isAssociationType()) continue;
                if (propertyType.isCollectionType()) {
                    propertyValue = this.getValueFromCollection(propertyValue);
                }
                if (propertyValue == null) continue;
                Criteria subCrit = crit.createCriteria(propertyName);
                String[] subProperties = this.append(walkedProperties, propertyName);
                this.createSubExamples(subCrit, propertyValue, subProperties);
            }
        }

        private Map<String, FilterMetadata> getFilterMetadata(String path) {
            HashMap<String, FilterMetadata> result = new HashMap<String, FilterMetadata>();
            for (String key : FilterMetadataSupport.this.filterMetadata.keySet()) {
                String leftover;
                if (key.equals(path) || !key.startsWith(path) || (leftover = key.substring(path.length() + 1)).contains(".")) continue;
                result.put(leftover, (FilterMetadata)FilterMetadataSupport.this.filterMetadata.get(key));
            }
            return result;
        }

        private String getPath(String[] walkedProperties) {
            return walkedProperties.length > 0 ? StringUtils.join((Object[])walkedProperties, (char)'.') : "";
        }

        private Example example(Object entity, Set<String> propertiesToExclude) {
            Example ex = Example.create((Object)entity);
            for (String propertyName : propertiesToExclude) {
                ex.excludeProperty(propertyName);
            }
            return ex;
        }

        private boolean alreadyWalked(String[] walkedProperties, String propertyName) {
            if (walkedProperties.length <= 2) {
                return false;
            }
            String parent = walkedProperties[walkedProperties.length - 1];
            boolean lastWasChild = false;
            for (int i = walkedProperties.length - 2; i > 0; --i) {
                String currPropertyName = walkedProperties[i];
                if (currPropertyName.equals(propertyName)) {
                    lastWasChild = true;
                    continue;
                }
                if (!lastWasChild) continue;
                if (currPropertyName.equals(parent)) {
                    return true;
                }
                lastWasChild = false;
            }
            return false;
        }

        private Object getValueFromCollection(Object collectionValue) {
            if (collectionValue != null) {
                Class<?> clazz;
                if (collectionValue instanceof Collection) {
                    Collection coll = (Collection)collectionValue;
                    int size = coll.size();
                    if (size == 1) {
                        return coll.iterator().next();
                    }
                    if (size > 1) {
                        throw new IllegalArgumentException("More than one element in filter collection is unsupported.");
                    }
                }
                if ((clazz = collectionValue.getClass()).isArray()) {
                    int length = Array.getLength(collectionValue);
                    if (length == 1) {
                        return Array.get(collectionValue, 0);
                    }
                    if (length > 1) {
                        throw new IllegalArgumentException("More than one element in filter array is unsupported.");
                    }
                }
            }
            return null;
        }

        private String[] append(String[] propertyNames, String propertyName) {
            String[] result = Arrays.copyOf(propertyNames, propertyNames.length + 1);
            result[propertyNames.length] = propertyName;
            return result;
        }
    }
}

