/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.example;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;

public class ExampleTree
implements Serializable {
    private static final long serialVersionUID = 4331039089117321853L;
    private final Object rootEntity;
    private Character escapeCharacter;
    private Example.PropertySelector selector;
    private DefaultPropertySelector defaultSelector = DefaultPropertySelector.NOT_NULL;
    private MatchMode matchMode;
    private boolean isIgnoreCaseEnabled;
    private Map<String, Set<String>> excludedProperties = new HashMap<String, Set<String>>();
    private Map<String, List<Criterion>> additionalConditions = new HashMap<String, List<Criterion>>();

    public ExampleTree(Object entity) {
        if (entity == null) {
            throw new NullPointerException("Null entity.");
        }
        this.rootEntity = entity;
    }

    public Criteria create(Session ses) {
        return this.appendTo(ses.createCriteria(Hibernate.getClass((Object)this.rootEntity)), ses);
    }

    public Criteria appendTo(Criteria crit, Session ses) {
        return new ExampleTreeWalker(ses).walk(crit);
    }

    public ExampleTree setEscapeCharacter(Character escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
        return this;
    }

    public ExampleTree setPropertySelector(Example.PropertySelector selector) {
        this.selector = selector;
        this.defaultSelector = null;
        return this;
    }

    public ExampleTree excludeZeroes() {
        return this.setDefaultSelector(DefaultPropertySelector.NOT_NULL_OR_ZERO);
    }

    public ExampleTree excludeNone() {
        return this.setDefaultSelector(DefaultPropertySelector.ALL);
    }

    public ExampleTree enableLike(MatchMode matchMode) {
        this.matchMode = matchMode;
        return this;
    }

    public ExampleTree enableLike() {
        return this.enableLike(MatchMode.EXACT);
    }

    public ExampleTree ignoreCase() {
        this.isIgnoreCaseEnabled = true;
        return this;
    }

    public ExampleTree add(String associationPath, Criterion criterion) {
        List<Criterion> criteriaForPath = this.additionalConditions.get(associationPath);
        if (criteriaForPath == null) {
            criteriaForPath = new ArrayList<Criterion>();
            this.additionalConditions.put(associationPath, criteriaForPath);
        }
        criteriaForPath.add(criterion);
        return this;
    }

    public ExampleTree excludeProperty(String associationPath, String propertyName) {
        Set<String> excludedPropertiesForPath = this.excludedProperties.get(associationPath);
        if (excludedPropertiesForPath == null) {
            excludedPropertiesForPath = new HashSet<String>();
            this.excludedProperties.put(associationPath, excludedPropertiesForPath);
        }
        excludedPropertiesForPath.add(propertyName);
        return this;
    }

    public ExampleTree overridePropertyFilter(String associationPath, String propertyName, Criterion override) {
        this.excludeProperty(associationPath, propertyName);
        return this.add(associationPath, override);
    }

    private ExampleTree setDefaultSelector(DefaultPropertySelector defaultSelector) {
        this.defaultSelector = defaultSelector;
        this.selector = null;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExampleTreeWalker
    implements Serializable {
        private static final long serialVersionUID = -5606122272375864522L;
        private final SessionFactory sessionFactory;
        private EntityMode entityMode;

        public ExampleTreeWalker(Session session) {
            this.sessionFactory = session.getSessionFactory();
            this.entityMode = session.getEntityMode();
        }

        public Criteria walk(Criteria rootCriteria) {
            this.createSubExamples(rootCriteria, ExampleTree.this.rootEntity, new String[0]);
            return rootCriteria;
        }

        private void createSubExamples(Criteria crit, Object entity, String[] walkedProperties) {
            String associationPath = this.getAssociationPath(walkedProperties);
            crit.add((Criterion)this.example(entity, associationPath));
            for (Criterion c : this.getAdditionalConditions(associationPath)) {
                crit.add(c);
            }
            ClassMetadata classMetadata = this.sessionFactory.getClassMetadata(Hibernate.getClass((Object)entity));
            Type[] types = classMetadata.getPropertyTypes();
            String[] names = classMetadata.getPropertyNames();
            for (int i = 0; i < types.length; ++i) {
                String propertyName;
                Type propertyType = types[i];
                if (!propertyType.isAssociationType() || this.alreadyWalked(walkedProperties, propertyName = names[i])) continue;
                Object propertyValue = classMetadata.getPropertyValue(entity, propertyName, this.entityMode);
                if (propertyType.isCollectionType()) {
                    propertyValue = this.getValueFromCollection(propertyValue);
                }
                if (propertyValue == null) continue;
                Criteria subCrit = crit.createCriteria(propertyName);
                String[] subProperties = this.append(walkedProperties, propertyName);
                this.createSubExamples(subCrit, propertyValue, subProperties);
            }
        }

        private String getAssociationPath(String[] walkedProperties) {
            return walkedProperties.length > 0 ? StringUtils.join((Object[])walkedProperties, (char)'.') : "";
        }

        private Example example(Object entity, String associationPath) {
            Example ex = Example.create((Object)entity);
            if (ExampleTree.this.escapeCharacter != null) {
                ex.setEscapeCharacter(ExampleTree.this.escapeCharacter);
            }
            if (ExampleTree.this.matchMode != null) {
                ex.enableLike(ExampleTree.this.matchMode);
            }
            if (ExampleTree.this.isIgnoreCaseEnabled) {
                ex.ignoreCase();
            }
            if (ExampleTree.this.selector != null) {
                ex.setPropertySelector(ExampleTree.this.selector);
            } else {
                switch (ExampleTree.this.defaultSelector) {
                    case NOT_NULL_OR_ZERO: {
                        ex.excludeZeroes();
                        break;
                    }
                    case ALL: {
                        ex.excludeNone();
                        break;
                    }
                }
            }
            Set excludedPropertiesForPath = (Set)ExampleTree.this.excludedProperties.get(associationPath);
            if (excludedPropertiesForPath != null) {
                for (String propertyName : excludedPropertiesForPath) {
                    ex.excludeProperty(propertyName);
                }
            }
            return ex;
        }

        private List<Criterion> getAdditionalConditions(String path) {
            List result = (List)ExampleTree.this.additionalConditions.get(path);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }

        private boolean alreadyWalked(String[] walkedProperties, String propertyName) {
            if (walkedProperties.length <= 2) {
                return false;
            }
            String parent = walkedProperties[walkedProperties.length - 1];
            boolean lastWasChild = false;
            for (int i = walkedProperties.length - 2; i > 0; --i) {
                String currPropertyName = walkedProperties[i];
                if (currPropertyName.equals(propertyName)) {
                    lastWasChild = true;
                    continue;
                }
                if (!lastWasChild) continue;
                if (currPropertyName.equals(parent)) {
                    return true;
                }
                lastWasChild = false;
            }
            return false;
        }

        private Object getValueFromCollection(Object collectionValue) {
            if (collectionValue != null) {
                Class<?> clazz;
                if (collectionValue instanceof Collection) {
                    Collection coll = (Collection)collectionValue;
                    int size = coll.size();
                    if (size == 1) {
                        return coll.iterator().next();
                    }
                    if (size > 1) {
                        throw new IllegalArgumentException("More than one element in filter collection is unsupported.");
                    }
                }
                if ((clazz = collectionValue.getClass()).isArray()) {
                    int length = Array.getLength(collectionValue);
                    if (length == 1) {
                        return Array.get(collectionValue, 0);
                    }
                    if (length > 1) {
                        throw new IllegalArgumentException("More than one element in filter array is unsupported.");
                    }
                }
            }
            return null;
        }

        private String[] append(String[] propertyNames, String propertyName) {
            String[] result = Arrays.copyOf(propertyNames, propertyNames.length + 1);
            result[propertyNames.length] = propertyName;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DefaultPropertySelector {
        NOT_NULL,
        NOT_NULL_OR_ZERO,
        ALL;

    }
}

