/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.example;

import it.openutils.hibernate.example.FilterMetadata;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnhancedExample {
    private static Logger log = LoggerFactory.getLogger(EnhancedExample.class);
    private Map<String, ? extends FilterMetadata> metadata;

    private EnhancedExample(Criteria crit, Object filter, Map<String, ? extends FilterMetadata> metadata) {
        this.metadata = metadata == null ? Collections.emptyMap() : metadata;
        this.fillCriteria(null, crit, filter);
    }

    public static void create(Criteria crit, Object filter, Map<String, ? extends FilterMetadata> metadata) throws HibernateException {
        new EnhancedExample(crit, filter, metadata);
    }

    private void addCondition(Criteria crit, String propertyName, Object value, Object parentObject) throws HibernateException {
        String simplePropertyName;
        String string = simplePropertyName = StringUtils.contains((String)propertyName, (String)".") ? StringUtils.substringAfterLast((String)propertyName, (String)".") : propertyName;
        if (this.isSimpleType(value) || value.getClass().isEnum()) {
            if (value instanceof String && StringUtils.isBlank((String)((String)value))) {
                return;
            }
            FilterMetadata fmd = this.metadata.get(propertyName);
            if (fmd == null) {
                fmd = FilterMetadata.EQUAL;
            }
            fmd.createFilter(crit, simplePropertyName, value);
        } else if (this.containsSomething(value)) {
            if ((value instanceof Set || value instanceof List) && !((Collection)value).isEmpty()) {
                for (Object element : (Collection)value) {
                    log.debug("crit.createCriteria({})", (Object)simplePropertyName);
                    Criteria childrenCriteria = crit.createCriteria(simplePropertyName);
                    this.fillCriteria(propertyName, childrenCriteria, element);
                }
            } else if (value instanceof Map && !((Map)value).isEmpty()) {
                FilterMetadata fmd = this.metadata.get(propertyName);
                if (fmd != null) {
                    fmd.createFilter(crit, simplePropertyName, value);
                } else {
                    log.warn("Maps are not handled without a FilterMetadata. Property is {} and value is {}.", (Object)propertyName, value);
                }
            } else {
                log.debug("crit.createCriteria({})", (Object)simplePropertyName);
                Criteria childrenCriteria = crit.createCriteria(simplePropertyName);
                this.fillCriteria(propertyName, childrenCriteria, value);
            }
        }
    }

    private boolean containsSomething(Object bean) {
        Map properties;
        Object coll;
        if (bean == null) {
            return false;
        }
        if (this.isSimpleType(bean) || bean.getClass().isEnum()) {
            return true;
        }
        if (bean instanceof Collection) {
            coll = (Collection)bean;
            if (coll.isEmpty()) {
                return false;
            }
            if (this.containsSomething(coll.iterator().next())) {
                return true;
            }
        } else if (bean instanceof Map) {
            coll = (Map)bean;
            if (coll.isEmpty()) {
                return false;
            }
            if (this.containsSomething(coll.values().iterator().next())) {
                return true;
            }
        }
        try {
            properties = PropertyUtils.describe((Object)bean);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.error("Unable to build filter, PropertyUtils.describe throws an exception while analizing class " + ClassUtils.getShortClassName((Object)bean, (String)"NULL"), e);
            return false;
        }
        for (Map.Entry property : properties.entrySet()) {
            Object propertyValue;
            if (!PropertyUtils.isWriteable((Object)bean, (String)((String)property.getKey())) || (propertyValue = property.getValue()) == null || !this.isSimpleType(propertyValue) && !this.containsSomething(propertyValue)) continue;
            return true;
        }
        return false;
    }

    private void fillCriteria(String parentPropertyName, Criteria crit, Object filter) throws HibernateException {
        Map properties;
        if ((filter instanceof Set || filter instanceof List) && !((Collection)filter).isEmpty()) {
            for (Object element : (Collection)filter) {
                this.fillCriteria(parentPropertyName, crit, element);
            }
        }
        try {
            properties = PropertyUtils.describe((Object)filter);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new DataRetrievalFailureException("Unable to build filter, PropertyUtils.describe throws an exception while analizing class " + ClassUtils.getShortClassName((Object)filter, (String)"NULL") + ":" + e.getClass(), e);
        }
        for (String propertyName : properties.keySet()) {
            Object value = properties.get(propertyName);
            if (value == null || !PropertyUtils.isWriteable((Object)filter, (String)propertyName)) continue;
            String composedPropertyName = parentPropertyName == null ? propertyName : parentPropertyName + "." + propertyName;
            this.addCondition(crit, composedPropertyName, value, filter);
        }
    }

    private boolean isSimpleType(Object object) {
        Class<?> objClass = object.getClass();
        return objClass.isPrimitive() || objClass.equals(Integer.class) || objClass.equals(Long.class) || objClass.equals(Short.class) || objClass.equals(Boolean.class) || objClass.equals(String.class) || objClass.equals(Double.class) || objClass.equals(Float.class) || objClass.equals(Date.class) || objClass.equals(Byte.class) || objClass.equals(BigDecimal.class) || objClass.equals(Timestamp.class) || objClass.equals(Character.class) || Calendar.class.isAssignableFrom(objClass);
    }
}

