/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.dao.hibernate;

import it.openutils.dao.hibernate.HibernateDAO;
import it.openutils.hibernate.example.ExampleTree;
import it.openutils.hibernate.example.FilterMetadata;
import it.openutils.hibernate.example.FilterMetadataSupport;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.AspectException;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.type.Type;
import org.springframework.aop.framework.AopContext;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateDAOImpl<T, K extends Serializable>
extends HibernateDaoSupport
implements HibernateDAO<T, K> {
    private Class<T> referenceClass;
    private boolean aopenabled;

    public HibernateDAOImpl() {
    }

    public HibernateDAOImpl(Class<T> referenceClass) {
        this.referenceClass = referenceClass;
    }

    @Override
    public List<T> findAll() {
        return this.getThis().find(Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public List<T> findAll(Order ... orders) {
        return this.getThis().find(Collections.emptyList(), orders);
    }

    @Override
    public List<T> find(List<? extends Criterion> criteria, Order ... orders) {
        final List<Object> actualCriteria = criteria != null ? criteria : Collections.emptyList();
        final List<Object> actualOrders = orders != null ? Arrays.asList(orders) : Collections.emptyList();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session ses) throws HibernateException {
                Criteria crit = ses.createCriteria(HibernateDAOImpl.this.getReferenceClass());
                for (Criterion c : actualCriteria) {
                    crit.add(c);
                }
                for (Order o : actualOrders) {
                    crit.addOrder(o);
                }
                return crit.list();
            }
        });
    }

    @Override
    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    @Override
    public List<T> find(String query, Object paramValue, Type paramType) {
        return this.getThis().find(query, new Object[]{paramValue}, new Type[]{paramType});
    }

    @Override
    public List<T> find(final String query, final Object[] paramValues, final Type[] paramTypes) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session ses) throws HibernateException {
                return ses.createQuery(query).setParameters(paramValues, paramTypes).list();
            }
        });
    }

    @Override
    public List<T> findFiltered(T filter) {
        return this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), Integer.MAX_VALUE, 0, Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public List<T> findFiltered(T filter, Order ... orders) {
        return this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), Integer.MAX_VALUE, 0, Collections.emptyList(), orders);
    }

    @Override
    public List<T> findFiltered(T filter, int maxResults, int page) {
        return this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), maxResults, page, Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, ? extends FilterMetadata> metadata) {
        return this.getThis().findFiltered(filter, metadata, Integer.MAX_VALUE, 0, Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page) {
        return this.getThis().findFiltered(filter, metadata, maxResults, page, Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public T findFilteredFirst(T filter) {
        return this.getFirstInCollection(this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), 1, 0, Collections.emptyList(), this.getDefaultOrder()));
    }

    @Override
    public T findFilteredFirst(T filter, Order ... orders) {
        return this.getFirstInCollection(this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), 1, 0, Collections.emptyList(), orders));
    }

    @Override
    public T findFilteredFirst(T filter, List<? extends Criterion> criteria) {
        return this.getFirstInCollection(this.getThis().findFiltered(filter, this.getDefaultFilterMetadata(), 1, 0, criteria, this.getDefaultOrder()));
    }

    @Override
    public T load(K key) {
        Object result = this.getHibernateTemplate().load(this.getReferenceClass(), key);
        Hibernate.initialize((Object)result);
        return (T)result;
    }

    @Override
    public T loadIfAvailable(K key) {
        try {
            Object result = this.getHibernateTemplate().get(this.getReferenceClass(), key);
            if (result != null) {
                Hibernate.initialize((Object)result);
                return (T)result;
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public T get(K key) {
        return (T)this.getHibernateTemplate().get(this.getReferenceClass(), key);
    }

    @Override
    public K save(T obj) {
        return (K)this.getHibernateTemplate().save(obj);
    }

    @Override
    public void update(T obj) {
        this.getHibernateTemplate().update(obj);
    }

    @Override
    public void saveOrUpdate(T obj) {
        this.getHibernateTemplate().saveOrUpdate(obj);
    }

    @Override
    public boolean delete(final K key) {
        return (Boolean)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Boolean>(){

            public Boolean doInHibernate(Session ses) throws HibernateException {
                ses.delete(ses.load(HibernateDAOImpl.this.getReferenceClass(), key));
                return true;
            }
        });
    }

    @Override
    public void refresh(T obj) {
        this.getHibernateTemplate().refresh(obj);
    }

    @Override
    public void evict(T obj) {
        this.getHibernateTemplate().evict(obj);
    }

    @Override
    public T merge(final T obj) {
        return (T)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                return ses.merge(obj);
            }
        });
    }

    @Override
    @Deprecated
    public List<T> findAll(Order[] orders, List<? extends Criterion> criteria) {
        return this.getThis().find(criteria, orders);
    }

    @Override
    public List<T> findFiltered(T filter, Order[] customOrder, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page) {
        return this.getThis().findFiltered(filter, metadata, maxResults, page, Collections.emptyList(), this.getDefaultOrder());
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page, Order ... orders) {
        return this.getThis().findFiltered(filter, metadata, maxResults, page, Collections.emptyList(), orders);
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page, List<? extends Criterion> criteria, Order ... orders) {
        if (metadata == null || metadata.isEmpty()) {
            return (List)this.getHibernateTemplate().execute((HibernateCallback)new ExampleTreeCallback(orders, criteria, maxResults, page, filter));
        }
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallbackForExecution(filter, page, maxResults, metadata, orders, criteria, Collections.emptyList()));
    }

    @Override
    public List<?> findFilteredProperties(T filter, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page, List<? extends Criterion> criteria, List<String> properties, Order ... orders) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallbackForExecution(filter, page, maxResults, metadata, orders, criteria, properties));
    }

    @Override
    @Deprecated
    public List<T> findFiltered(T filter, Order[] orders, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page, List<? extends Criterion> criteria) {
        return this.getThis().findFiltered(filter, metadata, maxResults, page, criteria, orders);
    }

    @Override
    @Deprecated
    public List<?> findFilteredProperties(T filter, Order[] orders, Map<String, ? extends FilterMetadata> metadata, int maxResults, int page, List<? extends Criterion> criteria, List<String> properties) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallbackForExecution(filter, page, maxResults, metadata, orders, criteria, properties));
    }

    public void setAopenabled(boolean aopenabled) {
        this.aopenabled = aopenabled;
    }

    public void setReferenceClass(Class<T> referenceClass) {
        this.referenceClass = referenceClass;
    }

    protected Class<T> getReferenceClass() {
        return this.referenceClass;
    }

    protected Order[] getDefaultOrder() {
        return new Order[0];
    }

    protected List<?> findByNamedQuery(final String name, final Serializable[] params, final Integer maxResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session ses) throws HibernateException {
                Query q = ses.getNamedQuery(name);
                if (maxResults != null) {
                    q.setMaxResults(maxResults.intValue());
                }
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        q.setParameter(i, (Object)params[i]);
                    }
                }
                return q.list();
            }
        });
    }

    protected List<?> findByNamedQuery(final String name, final Map<String, ?> params, final Integer maxResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session ses) throws HibernateException {
                Query q = ses.getNamedQuery(name);
                if (maxResults != null) {
                    q.setMaxResults(maxResults.intValue());
                }
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        HibernateDAOImpl.this.setParameterValue(q, (String)entry.getKey(), entry.getValue());
                    }
                }
                return q.list();
            }
        });
    }

    @Deprecated
    protected List<?> getNamedQuery(String name, Serializable[] params, int maxResults) {
        return this.findByNamedQuery(name, params, (Integer)(maxResults > 0 ? maxResults : Integer.MAX_VALUE));
    }

    @Deprecated
    protected List<?> getNamedQuery(String name, Map<String, ?> params, int maxResults) {
        return this.findByNamedQuery(name, params, (Integer)(maxResults > 0 ? maxResults : Integer.MAX_VALUE));
    }

    protected void setParameterValue(Query query, String key, Object value) {
        if (null == key || null == value) {
            return;
        }
        query.setParameter(key, value);
    }

    protected Map<String, ? extends FilterMetadata> getDefaultFilterMetadata() {
        return Collections.emptyMap();
    }

    private T getFirstInCollection(Collection<? extends T> list) {
        if (list != null && !list.isEmpty()) {
            T result = list.iterator().next();
            Hibernate.initialize(result);
            return result;
        }
        return null;
    }

    private HibernateDAO<T, K> getThis() {
        try {
            if (this.aopenabled) {
                return (HibernateDAO)AopContext.currentProxy();
            }
        }
        catch (AspectException exc) {
            this.logger.debug((Object)("Not running inside an AOP proxy, so no proxy can be returned: " + exc.getMessage()));
        }
        catch (IllegalStateException e) {
            this.logger.warn((Object)("Cannot access proxy: " + e.getMessage()));
            this.aopenabled = false;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HibernateCallbackForExecution
    implements HibernateCallback<List<T>> {
        private T filter;
        private int page;
        private int maxResults;
        private Map<String, ? extends FilterMetadata> metadata;
        private List<String> properties;
        private Order[] orderProperties;
        private List<? extends Criterion> additionalCriteria;

        private HibernateCallbackForExecution(T filter, int page, int maxResults, Map<String, ? extends FilterMetadata> metadata, Order[] orderProperties, List<? extends Criterion> additionalCriteria, List<String> properties) {
            this.filter = filter;
            this.page = page;
            this.maxResults = maxResults;
            this.metadata = metadata;
            this.orderProperties = orderProperties;
            this.additionalCriteria = additionalCriteria;
            this.properties = properties;
        }

        public List<T> doInHibernate(Session ses) throws HibernateException {
            Criteria crit = new FilterMetadataSupport(this.filter, this.metadata).create(ses);
            crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            crit.setMaxResults(this.maxResults);
            crit.setFirstResult(this.maxResults * this.page);
            if (this.orderProperties != null) {
                for (Order order : this.orderProperties) {
                    if (order == null) continue;
                    crit.addOrder(order);
                }
            }
            if (!CollectionUtils.isEmpty(this.additionalCriteria)) {
                for (Criterion criterion : this.additionalCriteria) {
                    crit.add(criterion);
                }
            }
            if (!CollectionUtils.isEmpty(this.properties)) {
                ProjectionList projectionList = Projections.projectionList();
                for (String property : this.properties) {
                    projectionList.add((Projection)Property.forName((String)property));
                }
                crit.setProjection((Projection)projectionList);
            }
            return crit.list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExampleTreeCallback
    implements HibernateCallback<List<T>> {
        private final Order[] orders;
        private final List<? extends Criterion> criteria;
        private final int page;
        private final int maxResults;
        private final T filter;

        private ExampleTreeCallback(Order[] orders, List<? extends Criterion> criteria, int maxResults, int page, T filter) {
            this.orders = orders;
            this.criteria = criteria;
            this.page = page;
            this.maxResults = maxResults;
            this.filter = filter;
        }

        public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
            Criteria crit = new ExampleTree(this.filter).create(session);
            crit.setMaxResults(this.maxResults);
            crit.setFirstResult(this.maxResults * this.page);
            if (this.criteria != null) {
                for (Criterion criterion : this.criteria) {
                    crit.add(criterion);
                }
            }
            if (this.orders != null) {
                for (Order o : this.orders) {
                    crit.addOrder(o);
                }
            }
            return crit.list();
        }
    }
}

