/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class JAXPVariable
implements VariableDeclaration,
Binding {
    private QNameValue name;
    private XPathVariableResolver resolver;

    public JAXPVariable(QNameValue qNameValue, XPathVariableResolver xPathVariableResolver) {
        this.name = qNameValue;
        this.resolver = xPathVariableResolver;
    }

    public boolean isGlobal() {
        return true;
    }

    public final boolean isAssignable() {
        return false;
    }

    public int getLocalSlotNumber() {
        return -1;
    }

    public String getVariableName() {
        return this.name.getStringValue();
    }

    public int getNameCode() {
        return -1;
    }

    public void registerReference(BindingReference bindingReference) {
        bindingReference.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        bindingReference.fixup((Binding)this);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        Object object = this.resolver.resolveVariable((QName)this.name.makeQName(xPathContext.getController().getConfiguration()));
        if (object == null) {
            return EmptySequence.getInstance();
        }
        return Value.convertJavaObjectToXPath((Object)object, (SequenceType)SequenceType.ANY_SEQUENCE, (Configuration)xPathContext.getController().getConfiguration());
    }

    QName makeQName(QNameValue qNameValue) {
        return new QName(qNameValue.getNamespaceURI(), qNameValue.getLocalName(), qNameValue.getPrefix());
    }
}

