/*
 * Decompiled with CFR 0.152.
 */
package com.cflex.util.lpSolve;

import com.cflex.util.lpSolve.Display;
import com.cflex.util.lpSolve.Solver;
import com.cflex.util.lpSolve.SolverListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class SolverViewer
extends JPanel
implements ActionListener,
SolverListener {
    public Solver solver;
    public Display display;
    public JButton playJB;
    public JButton pauseJB;
    public JButton stopJB;
    public JButton dismissJB;
    public JButton clearJB;
    public JCheckBox debugJCB;
    public JCheckBox verboseJCB;
    public JCheckBox traceJCB;
    public JTextArea messagesJTA;
    public ImageIcon canceledIMG;
    public ImageIcon optimalIMG;
    public ImageIcon unboundedIMG;
    public ImageIcon nofeasfoundIMG;
    public ImageIcon errorIMG;

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            if (actionEvent.getSource() != this.playJB) break block10;
                                            this.display.clearImage();
                                            this.solver.startSolver();
                                            this.stopJB.setEnabled(true);
                                            this.playJB.setEnabled(false);
                                            this.pauseJB.setEnabled(true);
                                            this.dismissJB.setEnabled(false);
                                            break block11;
                                        }
                                        if (actionEvent.getSource() != this.stopJB) break block12;
                                        this.solver.stopSolver();
                                        this.playJB.setEnabled(false);
                                        this.pauseJB.setEnabled(false);
                                        this.stopJB.setEnabled(false);
                                        this.dismissJB.setEnabled(true);
                                        break block11;
                                    }
                                    if (actionEvent.getSource() != this.pauseJB) break block13;
                                    if (this.solver.state == 3) {
                                        this.stopJB.setEnabled(false);
                                    } else {
                                        this.stopJB.setEnabled(true);
                                    }
                                    this.solver.pauseSolver();
                                    break block11;
                                }
                                if (actionEvent.getSource() != this.debugJCB) break block14;
                                this.solver.model.debug = this.debugJCB.isSelected() ? 1 : 0;
                                break block11;
                            }
                            if (actionEvent.getSource() != this.verboseJCB) break block15;
                            this.solver.model.verbose = this.verboseJCB.isSelected() ? 1 : 0;
                            break block11;
                        }
                        if (actionEvent.getSource() != this.traceJCB) break block16;
                        this.solver.model.trace = this.traceJCB.isSelected() ? 1 : 0;
                        break block11;
                    }
                    if (actionEvent.getSource() != this.clearJB) break block17;
                    this.messagesJTA.setText("");
                    break block11;
                }
                if (actionEvent.getSource() != this.dismissJB) break block11;
                if (this.solver.state == 5) break block18;
                if (this.solver.state != 6) break block11;
            }
            this.solver.model = null;
            this.solver = null;
            System.gc();
            Container container = this;
            while (container != null && !(container instanceof JInternalFrame) && !(container instanceof JFrame)) {
                container = container.getParent();
            }
            if (container != null) {
                if (container instanceof JInternalFrame) {
                    JInternalFrame jInternalFrame = (JInternalFrame)container;
                    jInternalFrame.setVisible(false);
                    jInternalFrame.dispose();
                } else if (container instanceof JFrame) {
                    JFrame jFrame = (JFrame)container;
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            }
        }
    }

    public SolverViewer() {
    }

    public SolverViewer(Solver solver) throws Exception {
        solver.viewer = this;
        solver.model.viewer = this;
        this.solver = solver;
        this.display = new Display();
        this.playJB = new JButton("Play");
        this.pauseJB = new JButton("Pause");
        this.stopJB = new JButton("Stop");
        this.clearJB = new JButton("Clear");
        this.dismissJB = new JButton("Dismiss");
        this.debugJCB = new JCheckBox("Debug");
        this.verboseJCB = new JCheckBox("Verbose");
        this.traceJCB = new JCheckBox("Trace");
        this.messagesJTA = new JTextArea();
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.playJB);
        jPanel.add(this.pauseJB);
        jPanel.add(this.stopJB);
        jPanel.add(this.dismissJB);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.debugJCB);
        jPanel2.add(this.verboseJCB);
        jPanel2.add(this.traceJCB);
        jPanel2.setBorder(new TitledBorder("Controls"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.clearJB, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)new JScrollPane(this.messagesJTA), "Center");
        jPanel4.add((Component)jPanel, "South");
        this.canceledIMG = this.loadImageIcon("images/canceled.gif");
        this.optimalIMG = this.loadImageIcon("images/optimal.gif");
        this.unboundedIMG = this.loadImageIcon("images/unbounded.gif");
        this.nofeasfoundIMG = this.loadImageIcon("images/nofeasfound.gif");
        this.errorIMG = this.loadImageIcon("images/error.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.display, "North");
        this.add((Component)jPanel4, "Center");
        this.playJB.addActionListener(this);
        this.pauseJB.addActionListener(this);
        this.stopJB.addActionListener(this);
        this.debugJCB.addActionListener(this);
        this.verboseJCB.addActionListener(this);
        this.traceJCB.addActionListener(this);
        this.clearJB.addActionListener(this);
        this.dismissJB.addActionListener(this);
        this.debugJCB.setSelected(solver.model.debug == 1);
        this.verboseJCB.setSelected(solver.model.verbose == 1);
        this.traceJCB.setSelected(solver.model.trace == 1);
        this.stopJB.setEnabled(false);
    }

    public ImageIcon loadImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL, null);
    }

    public void message(String string) {
        this.messagesJTA.append(string);
    }

    public void messageln(String string) {
        this.message(string + "\n");
    }

    public void errorMessage(String string) {
        this.messageln(string);
    }

    public void stepUpdate(long l) {
        this.display.timedSetValue(l);
    }

    public void stateChanged() {
        this.repaint(0L);
    }

    public void error(Exception exception) {
        exception.printStackTrace();
        this.display.setImage(this.errorIMG);
        this.messageln(exception.getClass().getName() + exception.getMessage());
        this.stopJB.setEnabled(false);
        this.playJB.setEnabled(false);
        this.pauseJB.setEnabled(false);
        this.dismissJB.setEnabled(true);
        this.repaint();
    }

    public void finished(int n) {
        switch (n) {
            case -1: {
                this.display.setImage(this.canceledIMG);
                break;
            }
            case 0: {
                this.display.setImage(this.optimalIMG);
                break;
            }
            case 3: {
                this.display.setImage(this.unboundedIMG);
                break;
            }
            case 1: {
                this.display.setImage(this.nofeasfoundIMG);
                break;
            }
            case 4: {
                this.display.setImage(this.nofeasfoundIMG);
                break;
            }
            case 2: {
                this.display.setImage(this.nofeasfoundIMG);
                break;
            }
            default: {
                this.display.setImage(this.errorIMG);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.stopJB.setEnabled(false);
        this.playJB.setEnabled(false);
        this.pauseJB.setEnabled(false);
        this.dismissJB.setEnabled(true);
        this.repaint();
    }
}

