/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.profiler;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Chrono {
    private static NumberFormat sFormatter = null;
    private static double sSpeed = -1.0;

    public static double start() {
        return System.nanoTime();
    }

    public static double stop(double dStart) {
        return ((double)System.nanoTime() - dStart) / 1000000.0;
    }

    public static boolean isHighResTimerAvailable() {
        return true;
    }

    public static String format(double t) {
        return sFormatter.format(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static double getOverheadPerMeasurement() {
        double speed = 0.0;
        Class<Chrono> clazz = Chrono.class;
        // MONITORENTER : net.sf.hulp.profiler.Chrono.class
        speed = sSpeed;
        // MONITOREXIT : clazz
        if (speed < 0.0) {
            for (int k = 0; k < 1000; ++k) {
                double ts = Chrono.start();
                Chrono.stop(ts);
            }
            double ts = Chrono.start();
            double dt = Chrono.stop(ts);
            int n = 0;
            do {
                Chrono.start();
                dt = Chrono.stop(ts);
                ++n;
            } while (!(dt > 500.0));
            speed = (double)n / dt;
            Class<Chrono> clazz2 = Chrono.class;
            // MONITORENTER : net.sf.hulp.profiler.Chrono.class
            sSpeed = speed;
            // MONITOREXIT : clazz2
        }
        if (!(speed > 0.0)) return 0.0;
        double d = 1.0 / speed;
        return d;
    }

    static {
        sFormatter = DecimalFormat.getInstance();
        sFormatter.setMaximumFractionDigits(3);
    }
}

