/*
 * Decompiled with CFR 0.152.
 */
package net.java.hulp.measure;

import java.util.List;
import java.util.regex.Pattern;
import javax.management.openmbean.TabularData;
import net.java.hulp.measure.internal.DelegatorFactory;
import net.java.hulp.measure.internal.FactoryFactoryV2;
import net.java.hulp.measure.internal.FactoryV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Probe {
    private static FactoryV2 sFactory;
    private static FactoryV2 sAlwaysOnFactory;
    private static Probe sVoidMeasurement;
    private static final String FACTORYNAME = "net.sf.hulp.profiler.FactoryFactory";

    protected Probe() {
    }

    public static Probe fine(Class source, String topic, String subTopic) {
        if (sVoidMeasurement != null) {
            return sVoidMeasurement;
        }
        return sFactory.createV2(10, source, topic, subTopic);
    }

    public static Probe fine(Class source, String topic) {
        return Probe.fine(source, topic, null);
    }

    public static Probe info(Class source, String topic, String subTopic) {
        return sAlwaysOnFactory != null ? sAlwaysOnFactory.createV2(5, source, topic, subTopic) : sVoidMeasurement;
    }

    public static Probe info(Class source, String topic) {
        return sAlwaysOnFactory != null ? sAlwaysOnFactory.createV2(5, source, topic, null) : sVoidMeasurement;
    }

    public static boolean isFine() {
        return sVoidMeasurement == null;
    }

    public static boolean isInfo() {
        return sAlwaysOnFactory != null;
    }

    public static TabularData getData(List<Pattern[]> criteria) {
        return sAlwaysOnFactory == null ? null : sAlwaysOnFactory.getData(criteria);
    }

    public void end() {
    }

    public void setTopic(String topic) {
    }

    public void setSubtopic(String subTopic) {
    }

    public static void clearData(List<Pattern[]> criteria) {
        if (sAlwaysOnFactory != null) {
            sAlwaysOnFactory.clearData(criteria);
        }
    }

    static {
        try {
            String name = System.getProperty(FACTORYNAME, FACTORYNAME);
            Class<?> cFF = Class.forName(name);
            Class<?> cparentFF = null;
            try {
                cparentFF = Probe.class.getClassLoader().getParent().loadClass(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            Class<?> cparentProbe = null;
            try {
                cparentProbe = Probe.class.getClassLoader().getParent().loadClass(Probe.class.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cparentFF != null && cFF != cparentFF || cparentProbe != null && cparentProbe != Probe.class) {
                Object factoryfactory = cparentFF.newInstance();
                Object alwaysonfactory = cparentFF.getMethod("newAlwaysOnFactoryV2", new Class[0]).invoke(factoryfactory, new Object[0]);
                sAlwaysOnFactory = new DelegatorFactory(alwaysonfactory);
                Object factory = cparentFF.getMethod("newFactoryV2", new Class[0]).invoke(factoryfactory, new Object[0]);
                sFactory = new DelegatorFactory(factory);
                System.out.println("Delegating measurement factory loaded: " + name + " (" + sFactory + ")");
            } else {
                FactoryFactoryV2 f = (FactoryFactoryV2)cFF.newInstance();
                sAlwaysOnFactory = f.newAlwaysOnFactoryV2();
                sFactory = f.newFactoryV2();
                System.out.println("Measurement factory loaded: " + name + " (" + sFactory + ")");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sFactory == null) {
            sVoidMeasurement = new Probe();
        }
    }
}

