/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableCopyMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> map = new HashMap();
    private Object mutex = new Object();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this.mutex;
        synchronized (object) {
            HashMap<K, V> copy = new HashMap<K, V>();
            copy.putAll(this.map);
            copy.put(key, value);
            this.map = copy;
            return value;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            HashMap<K, V> copy = new HashMap<K, V>();
            copy.putAll(this.map);
            Object value = copy.remove(key);
            this.map = copy;
            return value;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

