/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwtwidgets.server.spring.DefaultSerializationPolicyProvider;
import org.gwtwidgets.server.spring.ModulePathTranslation;
import org.gwtwidgets.server.spring.RPCServiceExporter;
import org.gwtwidgets.server.spring.ReflectionUtils;
import org.gwtwidgets.server.spring.SerializationPolicyProvider;
import org.gwtwidgets.server.spring.ServletUtils;
import org.gwtwidgets.server.spring.util.ImmutableCopyMap;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTRPCServiceExporter
extends RemoteServiceServlet
implements RPCServiceExporter,
ServletContextAware,
ServletConfigAware,
BeanNameAware {
    public static final int COMPRESSION_DISABLED = 0;
    public static final int COMPRESSION_AUTO = 1;
    public static final int COMPRESSION_ENABLED = 2;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Class<?>[] serviceInterfaces;
    protected Object service = this;
    protected ServletContext servletContext;
    protected int compressResponse = 1;
    protected boolean disableResponseCaching = false;
    protected boolean throwUndeclaredExceptionToServletContainer = false;
    protected String beanName = "GWTRPCServiceExporter";
    protected SerializationPolicyProvider serializationPolicyProvider = new DefaultSerializationPolicyProvider();
    protected int serializationFlags = 0;
    protected boolean shouldCheckPermutationStrongName = false;
    protected ModulePathTranslation modulePathTranslation = new ModulePathTranslation(){

        public String computeModuleBaseURL(HttpServletRequest request, String moduleBaseURL, String strongName) {
            return moduleBaseURL;
        }
    };
    protected Map<Method, Method> methodCache = new ImmutableCopyMap<Method, Method>();

    public void setModulePathTranslation(ModulePathTranslation modulePathTranslation) {
        this.modulePathTranslation = modulePathTranslation;
    }

    protected void checkPermutationStrongName() {
        if (this.shouldCheckPermutationStrongName) {
            super.checkPermutationStrongName();
        }
    }

    @Override
    public void setShouldCheckPermutationStrongName(boolean shouldCheckPermutationStrongName) {
        this.shouldCheckPermutationStrongName = shouldCheckPermutationStrongName;
    }

    public int getSerializationFlags() {
        return this.serializationFlags;
    }

    public void setSerializationFlags(int serializationFlags) {
        this.serializationFlags = serializationFlags;
    }

    protected String processResponse(String response) {
        return response;
    }

    protected void doUnexpectedFailure(Throwable e) {
        super.doUnexpectedFailure(e);
        if (this.throwUndeclaredExceptionToServletContainer) {
            throw new RuntimeException(e);
        }
    }

    protected void preprocessHTTP(HttpServletRequest request, HttpServletResponse response) {
        if (this.disableResponseCaching) {
            ServletUtils.disableResponseCaching(response);
        }
    }

    public SerializationPolicyProvider getSerializationPolicyProvider() {
        return this.serializationPolicyProvider;
    }

    public void setSerializationPolicyProvider(SerializationPolicyProvider serializationPolicyProvider) {
        this.serializationPolicyProvider = serializationPolicyProvider;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Serialised RPC response: [" + serializedResponse + "]"));
        }
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Serialised RPC request: [" + serializedRequest + "]"));
        }
    }

    protected String invokeMethodOnService(Object service, Method targetMethod, Object[] targetParameters, RPCRequest rpcRequest) throws Exception {
        Object result = targetMethod.invoke(service, targetParameters);
        SerializationPolicy serializationPolicy = this.getSerializationPolicyProvider().getSerializationPolicyForSuccess(rpcRequest, service, targetMethod, targetParameters, result);
        String encodedResult = RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)result, (SerializationPolicy)serializationPolicy, (int)this.serializationFlags);
        return encodedResult;
    }

    protected String handleIllegalArgumentException(IllegalArgumentException e, Object service, Method targetMethod, RPCRequest rpcRequest) {
        SecurityException securityException = new SecurityException("Blocked attempt to invoke method " + targetMethod);
        securityException.initCause(e);
        throw securityException;
    }

    protected String handleIllegalAccessException(IllegalAccessException e, Object service, Method targetMethod, RPCRequest rpcRequest) {
        SecurityException securityException = new SecurityException("Blocked attempt to access inaccessible method " + targetMethod + (service != null ? " on service " + service : ""));
        securityException.initCause(e);
        throw securityException;
    }

    protected String encodeResponseForFailure(RPCRequest rpcRequest, Throwable cause, Method targetMethod, Object[] targetParameters) throws SerializationException {
        SerializationPolicy serializationPolicy = this.getSerializationPolicyProvider().getSerializationPolicyForFailure(rpcRequest, this.service, targetMethod, targetParameters, cause);
        return RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)cause, (SerializationPolicy)serializationPolicy, (int)this.serializationFlags);
    }

    protected String handleInvocationTargetException(InvocationTargetException e, Object service, Method targetMethod, Object[] parameters, RPCRequest rpcRequest) throws Exception {
        Throwable cause = e.getCause();
        if (!(cause instanceof RuntimeException)) {
            this.logger.warn((Object)cause);
        }
        return this.encodeResponseForFailure(rpcRequest, cause, targetMethod, parameters);
    }

    protected String handleServiceException(Exception e, Object service, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        throw e;
    }

    protected String handleUndeclaredThrowableException(Exception e, Object service, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        throw e;
    }

    protected Method getMethodToInvoke(Method decodedMethod) throws NoSuchMethodException {
        Method method = this.methodCache.get(decodedMethod);
        if (method != null) {
            return method;
        }
        method = ReflectionUtils.getRPCMethod(this.service, this.serviceInterfaces, decodedMethod);
        return this.methodCache.put(decodedMethod, method);
    }

    public String processCall(String payload) throws SerializationException {
        try {
            this.checkPermutationStrongName();
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, null, (com.google.gwt.user.server.rpc.SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            Method targetMethod = this.getMethodToInvoke(rpcRequest.getMethod());
            Object[] targetParameters = rpcRequest.getParameters();
            try {
                return this.processResponse(this.invokeMethodOnService(this.service, targetMethod, targetParameters, rpcRequest));
            }
            catch (IllegalArgumentException e) {
                return this.processResponse(this.handleIllegalArgumentException(e, this.service, targetMethod, rpcRequest));
            }
            catch (IllegalAccessException e) {
                return this.processResponse(this.handleIllegalAccessException(e, this.service, targetMethod, rpcRequest));
            }
            catch (InvocationTargetException e) {
                return this.processResponse(this.handleInvocationTargetException(e, this.service, targetMethod, targetParameters, rpcRequest));
            }
            catch (UndeclaredThrowableException e) {
                return this.processResponse(this.handleUndeclaredThrowableException(e, this.service, targetMethod, rpcRequest));
            }
            catch (Exception e) {
                return this.processResponse(this.handleServiceException(e, this.service, targetMethod, rpcRequest));
            }
        }
        catch (IncompatibleRemoteServiceException e) {
            return this.processResponse(this.handleIncompatibleRemoteServiceException(e));
        }
        catch (Exception e) {
            return this.processResponse(this.handleExporterProcessingException(e));
        }
    }

    protected String handleIncompatibleRemoteServiceException(IncompatibleRemoteServiceException cause) throws SerializationException {
        this.logger.warn((Object)cause.getMessage());
        return RPC.encodeResponseForFailure(null, (Throwable)cause);
    }

    protected String handleExporterProcessingException(Exception e) {
        throw new RuntimeException(e);
    }

    @Override
    public void setService(Object service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.preprocessHTTP(request, response);
            ServletUtils.setResponse(response);
            this.doPost(request, response);
            ModelAndView modelAndView = null;
            return modelAndView;
        }
        finally {
            ServletUtils.setResponse(null);
        }
    }

    @Override
    public void setServiceInterfaces(Class<RemoteService>[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            throw new Exception("You must specify a service object.");
        }
        if (this.serviceInterfaces == null) {
            this.logger.debug((Object)"Discovering service interfaces");
            this.serviceInterfaces = ReflectionUtils.getExposedInterfaces(this.service.getClass());
            if (this.serviceInterfaces.length == 0) {
                this.logger.warn((Object)"The specified service does neither implement RemoteService nor were any service interfaces specified. RPC access to *all* object methods is allowed.");
            }
        }
        if (this.servletContext == null) {
            this.logger.warn((Object)"No servlet context found. You should declare a GWTRPCServiceExporter or GWTHandler in a servlet context and not the application context.");
        }
    }

    public Object getService() {
        return this.service;
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        switch (this.compressResponse) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return super.shouldCompressResponse(request, response, responsePayload);
    }

    protected void setCompressResponse(int compressResponse) {
        if (compressResponse != 2 && compressResponse != 0 && compressResponse != 1) {
            throw new IllegalArgumentException("Invalid compressResponse argumnet " + compressResponse);
        }
        this.compressResponse = compressResponse;
    }

    @Override
    public void setResponseCachingDisabled(boolean disableResponseCaching) {
        this.disableResponseCaching = disableResponseCaching;
    }

    @Override
    public void setThrowUndeclaredExceptionToServletContainer(boolean throwUndeclaredExceptionToServletContainer) {
        this.throwUndeclaredExceptionToServletContainer = throwUndeclaredExceptionToServletContainer;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        try {
            this.init(servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String newModuleBaseURL = this.modulePathTranslation.computeModuleBaseURL(request, moduleBaseURL, strongName);
        return super.doGetSerializationPolicy(request, newModuleBaseURL, strongName);
    }

    public String toString() {
        return this.beanName;
    }
}

