/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.client.stream;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Timer;
import java.util.Date;
import org.gwtwidgets.client.stream.Message;
import org.gwtwidgets.client.stream.StreamCallback;

public class HtmlStreamReader {
    protected IFrameElement frame;
    protected long pollingInterval = 1000L;
    protected long maxAge = 300000L;
    protected Timer timer;
    protected Date dateOfCreation;
    protected int lastMessageId = -1;

    private boolean isObsolete() {
        Date now = new Date();
        long diff = now.getTime() - this.dateOfCreation.getTime();
        return diff > this.maxAge;
    }

    protected native Document getFrameContents(IFrameElement var1);

    private Message decodeMessage(Element e) {
        Message message = new Message();
        String content = e.getInnerText();
        String[] parts = content.split(",");
        message.setContent(URL.decodeQueryString((String)parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            String[] keyValuePair = parts[i].split("=");
            message.getAttributes().put(URL.decodeQueryString((String)keyValuePair[0]), URL.decodeQueryString((String)keyValuePair[1]));
        }
        message.setSerialNumber(Integer.parseInt(e.getAttribute("id")));
        return message;
    }

    private Message checkForEOF(Document document) {
        NodeList eSpans = document.getElementsByTagName("span");
        if (eSpans.getLength() == 0) {
            return null;
        }
        Element eSpan = (Element)eSpans.getItem(0);
        if ("EOF".equals(eSpan.getInnerText())) {
            Message message = new Message();
            message.setEOF(true);
            return message;
        }
        return null;
    }

    protected Message readNextMessage() {
        Document document = this.getFrameContents(this.frame);
        if (null == document) {
            return null;
        }
        NodeList elements = document.getElementsByTagName("div");
        if (elements.getLength() == 0) {
            return this.checkForEOF(document);
        }
        Element eDiv = (Element)elements.getItem(0);
        eDiv.getParentElement().removeChild((Node)eDiv);
        Message message = this.decodeMessage(eDiv);
        this.lastMessageId = message.getSerialNumber();
        return message;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    protected Element getFrame() {
        return this.frame;
    }

    public void setInnerFrameVisibility(boolean status) {
    }

    public void readAsync(final String url, final StreamCallback callback) {
        GWT.log((String)("Openeing stream to " + url), null);
        String sUrl = url + (url.contains("&") ? "&" : "?") + "lastmessageid=" + this.lastMessageId;
        this.dateOfCreation = new Date();
        this.frame = Document.get().createIFrameElement();
        this.setInnerFrameVisibility(false);
        Document.get().getBody().appendChild((Node)this.frame);
        this.frame.setSrc(sUrl);
        this.timer = new Timer(){

            public void run() {
                try {
                    Message message = null;
                    while (null != (message = HtmlStreamReader.this.readNextMessage())) {
                        if (message.isEOF()) {
                            HtmlStreamReader.this.close();
                            callback.onDisconnect();
                            return;
                        }
                        callback.onMessage(message);
                    }
                    if (HtmlStreamReader.this.isObsolete()) {
                        HtmlStreamReader.this.reconnect(url, callback);
                        return;
                    }
                    HtmlStreamReader.this.timer.schedule((int)HtmlStreamReader.this.getPollingInterval());
                }
                catch (Exception e) {
                    HtmlStreamReader.this.close();
                    callback.onError(e);
                }
            }
        };
        this.timer.schedule((int)this.getPollingInterval());
    }

    protected void reconnect(String url, StreamCallback callback) {
        GWT.log((String)("Refreshing connection to server with id " + this.lastMessageId), null);
        this.close();
        this.readAsync(url, callback);
    }

    public void close() {
        this.frame.setSrc("");
        this.timer.cancel();
        this.frame.getParentElement().removeChild((Node)this.frame);
        this.frame = null;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }
}

