/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config.generator;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.generator.model.NodeElementVisitor;
import net.sf.ehcache.config.generator.model.XMLGeneratorVisitor;
import net.sf.ehcache.config.generator.model.elements.CacheConfigurationElement;
import net.sf.ehcache.config.generator.model.elements.ConfigurationElement;

public abstract class ConfigurationUtil {
    public static String generateCacheManagerConfigurationText(Configuration configuration) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        XMLGeneratorVisitor configGenerator = new XMLGeneratorVisitor(out);
        configGenerator.disableOutputBehavior(XMLGeneratorVisitor.OutputBehavior.OUTPUT_OPTIONAL_ATTRIBUTES_WITH_DEFAULT_VALUES);
        ConfigurationUtil.visitConfiguration(configuration, configGenerator);
        out.flush();
        out.close();
        return baos.toString();
    }

    static void visitConfiguration(Configuration configuration, NodeElementVisitor visitor) {
        ConfigurationElement configElement = new ConfigurationElement(configuration);
        configElement.accept(visitor);
    }

    public static String generateCacheConfigurationText(CacheConfiguration cacheConfiguration) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        XMLGeneratorVisitor configGenerator = new XMLGeneratorVisitor(out);
        configGenerator.disableOutputBehavior(XMLGeneratorVisitor.OutputBehavior.OUTPUT_OPTIONAL_ATTRIBUTES_WITH_DEFAULT_VALUES);
        ConfigurationUtil.visitCacheConfiguration(cacheConfiguration, configGenerator);
        out.flush();
        out.close();
        return baos.toString();
    }

    static void visitCacheConfiguration(CacheConfiguration cacheConfiguration, NodeElementVisitor configGenerator) {
        CacheConfigurationElement element = new CacheConfigurationElement(null, cacheConfiguration);
        element.accept(configGenerator);
    }
}

