/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.tm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.ehcache.hibernate.tm.SyncTransactionManager;
import net.sf.ehcache.hibernate.tm.SyncXid;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;

public class SyncTransaction
implements Transaction {
    private final SyncTransactionManager syncTransactionManager;
    private Xid xid = new SyncXid();
    private List<Synchronization> syncs = new ArrayList<Synchronization>();
    private int status;
    private SortedSet<EhcacheXAResource> resources = new TreeSet<EhcacheXAResource>(new Comparator<EhcacheXAResource>(){

        @Override
        public int compare(EhcacheXAResource o1, EhcacheXAResource o2) {
            return o1.getCacheName().compareTo(o2.getCacheName());
        }
    });

    public SyncTransaction(SyncTransactionManager syncTransactionManager) {
        this.syncTransactionManager = syncTransactionManager;
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        this.status = 8;
        boolean i = false;
        for (EhcacheXAResource resource : this.resources) {
            try {
                resource.commit(this.xid, true);
            }
            catch (XAException e) {
                throw new RuntimeException(e);
            }
        }
        this.syncTransactionManager.setTransaction(null);
        this.status = 3;
        this.afterCompletion();
    }

    public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
        return this.resources.contains(xaResource);
    }

    public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
        boolean enlisted = false;
        if (xaResource instanceof EhcacheXAResource && this.resources.add((EhcacheXAResource)xaResource)) {
            enlisted = true;
            try {
                xaResource.start(this.xid, 0);
            }
            catch (XAException e) {
                throw new RuntimeException(e);
            }
        }
        return enlisted;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
        this.syncs.add(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 9;
        for (EhcacheXAResource resource : this.resources) {
            try {
                resource.rollback(this.xid);
            }
            catch (XAException e) {
                throw new RuntimeException(e);
            }
        }
        this.syncTransactionManager.setTransaction(null);
        this.status = 4;
        this.afterCompletion();
    }

    private void afterCompletion() {
        for (Synchronization sync : this.syncs) {
            sync.afterCompletion(this.status);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    void beforeCompletion() {
        for (Synchronization sync : this.syncs) {
            sync.beforeCompletion();
        }
    }
}

