/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.TerracottaConfiguration;
import org.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateUtil.class);

    private HibernateUtil() {
    }

    static Configuration loadAndCorrectConfiguration(URL url) {
        Configuration config = ConfigurationFactory.parseConfiguration(url);
        if (config.getDefaultCacheConfiguration().isTerracottaClustered() && TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)config.getDefaultCacheConfiguration().getTerracottaConfiguration().getValueMode())) {
            LOG.warn("The default cache value mode for this Ehcache configuration is \"identity\". This is incompatible with clustered Hibernate caching - the value mode has therefore been switched to \"serialization\"");
            config.getDefaultCacheConfiguration().getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
        }
        for (CacheConfiguration cacheConfig : config.getCacheConfigurations().values()) {
            if (!cacheConfig.isTerracottaClustered() || !TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)cacheConfig.getTerracottaConfiguration().getValueMode())) continue;
            LOG.warn("The value mode for the {0} cache is \"identity\". This is incompatible with clustered Hibernate caching - the value mode has therefore been switched to \"serialization\"", (Object)cacheConfig.getName());
            cacheConfig.getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
        }
        return config;
    }

    static void validateEhcache(Ehcache cache) throws CacheException {
        CacheConfiguration cacheConfig = cache.getCacheConfiguration();
        if (cacheConfig.isTerracottaClustered()) {
            TerracottaConfiguration tcConfig = cacheConfig.getTerracottaConfiguration();
            switch (tcConfig.getValueMode()) {
                case IDENTITY: {
                    throw new CacheException("The clustered Hibernate cache " + cache.getName() + " is using IDENTITY value mode.\n" + "Identity value mode cannot be used with Hibernate cache regions.");
                }
            }
        }
    }
}

