/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import java.util.Collections;
import java.util.HashSet;
import net.objectlab.kit.datecalc.common.AbstractDateCalculator;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.WorkingWeek;
import net.objectlab.kit.datecalc.joda.HolidayHandlerYearMonthDayWrapper;
import net.objectlab.kit.datecalc.joda.LocalDateCalculator;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YearMonthDayDateCalculator
extends AbstractDateCalculator<YearMonthDay> {
    private LocalDateCalculator delegate;

    public YearMonthDayDateCalculator() {
        this(null, null, new DefaultHolidayCalendar<YearMonthDay>(Collections.EMPTY_SET), null);
    }

    public YearMonthDayDateCalculator(String name, YearMonthDay startDate, HolidayCalendar<YearMonthDay> nonWorkingDays, HolidayHandler<YearMonthDay> holidayHandler) {
        super(name, nonWorkingDays, holidayHandler);
        HashSet<LocalDate> dates = new HashSet<LocalDate>();
        for (YearMonthDay d : nonWorkingDays.getHolidays()) {
            dates.add(d.toLocalDate());
        }
        YearMonthDay early = nonWorkingDays.getEarlyBoundary();
        YearMonthDay late = nonWorkingDays.getLateBoundary();
        DefaultHolidayCalendar<LocalDate> cal = new DefaultHolidayCalendar<LocalDate>(dates, early != null ? new LocalDate((Object)early) : null, late != null ? new LocalDate((Object)late) : null);
        HolidayHandlerYearMonthDayWrapper locDate = new HolidayHandlerYearMonthDayWrapper(holidayHandler, this);
        this.delegate = new LocalDateCalculator(name, startDate != null ? startDate.toLocalDate() : null, cal, locDate);
        this.setStartDate(startDate);
    }

    @Override
    public void setWorkingWeek(WorkingWeek week) {
        this.delegate.setWorkingWeek(week);
    }

    @Override
    public boolean isWeekend(YearMonthDay date) {
        if (date != null && this.delegate != null) {
            return this.delegate.isWeekend(date.toLocalDate());
        }
        return false;
    }

    @Override
    public DateCalculator<YearMonthDay> moveByDays(int days) {
        this.setCurrentIncrement(days);
        this.delegate.setCurrentIncrement(days);
        this.delegate.setCurrentBusinessDate(((YearMonthDay)this.getCurrentBusinessDate()).toLocalDate());
        this.setCurrentBusinessDate(new YearMonthDay((Object)this.delegate.moveByDays(days).getCurrentBusinessDate()));
        return this;
    }

    @Override
    protected DateCalculator<YearMonthDay> createNewCalculator(String name, YearMonthDay startDate, HolidayCalendar<YearMonthDay> holidays, HolidayHandler<YearMonthDay> handler) {
        return new YearMonthDayDateCalculator(name, startDate, holidays, handler);
    }

    @Override
    public final void setStartDate(YearMonthDay startDate) {
        if (this.delegate != null) {
            this.delegate.setStartDate(startDate != null ? startDate.toLocalDate() : null);
        }
        super.setStartDate(startDate);
    }

    @Override
    protected YearMonthDay getToday() {
        return new YearMonthDay();
    }

    @Override
    protected DateCalculator<YearMonthDay> moveByMonths(int months) {
        this.setCurrentIncrement(months);
        this.delegate.setCurrentIncrement(months);
        this.delegate.setCurrentBusinessDate(((YearMonthDay)this.getCurrentBusinessDate()).toLocalDate());
        this.setCurrentBusinessDate(new YearMonthDay((Object)this.delegate.moveByMonths(months).getCurrentBusinessDate()));
        return this;
    }

    @Override
    protected YearMonthDay compareDate(YearMonthDay date1, YearMonthDay date2, boolean returnEarliest) {
        if (date1 == null || date2 == null) {
            return null;
        }
        if (returnEarliest) {
            return date1.isAfter((ReadablePartial)date2) ? date2 : date1;
        }
        return date2.isAfter((ReadablePartial)date1) ? date2 : date1;
    }

    @Override
    protected void checkBoundary(YearMonthDay date) {
        YearMonthDay early = (YearMonthDay)this.getHolidayCalendar().getEarlyBoundary();
        if (early != null && early.isAfter((ReadablePartial)date)) {
            throw new IndexOutOfBoundsException(date + " is before the early boundary " + early);
        }
        YearMonthDay late = (YearMonthDay)this.getHolidayCalendar().getLateBoundary();
        if (late != null && late.isBefore((ReadablePartial)date)) {
            throw new IndexOutOfBoundsException(date + " is after the late boundary " + late);
        }
    }

    @Override
    protected YearMonthDay clone(YearMonthDay date) {
        return date;
    }
}

