/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.net.InetSocketAddress;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.exc.InvalidFormatException;

public class InetSocketAddressDeserializer
extends FromStringDeserializer<InetSocketAddress> {
    private static final long serialVersionUID = 1L;
    public static final InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

    public InetSocketAddressDeserializer() {
        super(InetSocketAddress.class);
    }

    @Override
    protected InetSocketAddress _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
        if (string.startsWith("[")) {
            int n = string.lastIndexOf(93);
            if (n == -1) {
                throw new InvalidFormatException("Bracketed IPv6 address must contain closing bracket.", string, InetSocketAddress.class);
            }
            int n2 = string.indexOf(58, n);
            int n3 = n2 > -1 ? Integer.parseInt(string.substring(n2 + 1)) : 0;
            return new InetSocketAddress(string.substring(0, n + 1), n3);
        }
        int n = string.indexOf(58);
        if (n != -1 && string.indexOf(58, n + 1) == -1) {
            int n4 = Integer.parseInt(string.substring(n));
            return new InetSocketAddress(string.substring(0, n), n4);
        }
        return new InetSocketAddress(string, 0);
    }
}

