/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParser;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;

public final class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final Object[] _creatorParameters;
    protected final ObjectIdReader _objectIdReader;
    private int _paramsNeeded;
    private PropertyValue _buffered;
    private Object _idValue;

    public PropertyValueBuffer(JsonParser jsonParser, DeserializationContext deserializationContext, int n, ObjectIdReader objectIdReader) {
        this._parser = jsonParser;
        this._context = deserializationContext;
        this._paramsNeeded = n;
        this._objectIdReader = objectIdReader;
        this._creatorParameters = new Object[n];
    }

    public void inject(SettableBeanProperty[] settableBeanPropertyArray) {
        for (SettableBeanProperty settableBeanProperty : settableBeanPropertyArray) {
            if (settableBeanProperty == null) continue;
            this._creatorParameters[var2_2] = this._context.findInjectableValue(settableBeanProperty.getInjectableValueId(), settableBeanProperty, null);
        }
    }

    protected final Object[] getParameters(Object[] objectArray) {
        if (objectArray != null) {
            int n = this._creatorParameters.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (this._creatorParameters[i] != null || (object = objectArray[i]) == null) continue;
                this._creatorParameters[i] = object;
            }
        }
        return this._creatorParameters;
    }

    public boolean readIdProperty(String string) throws IOException {
        if (this._objectIdReader != null && string.equals(this._objectIdReader.propertyName.getSimpleName())) {
            this._idValue = this._objectIdReader.readObjectReference(this._parser, this._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._objectIdReader != null && this._idValue != null) {
            ReadableObjectId readableObjectId = deserializationContext.findObjectId(this._idValue, this._objectIdReader.generator);
            readableObjectId.bindItem(object);
            SettableBeanProperty settableBeanProperty = this._objectIdReader.idProperty;
            if (settableBeanProperty != null) {
                return settableBeanProperty.setAndReturn(object, this._idValue);
            }
        }
        return object;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(int n, Object object) {
        this._creatorParameters[n] = object;
        return --this._paramsNeeded <= 0;
    }

    public void bufferProperty(SettableBeanProperty settableBeanProperty, Object object) {
        this._buffered = new PropertyValue.Regular(this._buffered, object, settableBeanProperty);
    }

    public void bufferAnyProperty(SettableAnyProperty settableAnyProperty, String string, Object object) {
        this._buffered = new PropertyValue.Any(this._buffered, object, settableAnyProperty, string);
    }

    public void bufferMapProperty(Object object, Object object2) {
        this._buffered = new PropertyValue.Map(this._buffered, object2, object);
    }
}

