/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParser;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonProcessingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonToken;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.BeanProperty;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JavaType;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonMappingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class SettableAnyProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final transient Method _setter;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    @Deprecated
    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMethod annotatedMethod, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        this(beanProperty, annotatedMethod, javaType, jsonDeserializer, null);
    }

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMethod annotatedMethod, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this(beanProperty, annotatedMethod.getAnnotated(), javaType, jsonDeserializer, typeDeserializer);
    }

    @Deprecated
    public SettableAnyProperty(BeanProperty beanProperty, Method method, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        this(beanProperty, method, javaType, jsonDeserializer, null);
    }

    public SettableAnyProperty(BeanProperty beanProperty, Method method, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._type = javaType;
        this._setter = method;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
    }

    public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
        return new SettableAnyProperty(this._property, this._setter, this._type, jsonDeserializer, this._valueTypeDeserializer);
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException, JsonProcessingException {
        this.set(object, string, this.deserialize(jsonParser, deserializationContext));
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public void set(Object object, String string, Object object2) throws IOException {
        try {
            this._setter.invoke(object, string, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, string, object2);
        }
    }

    protected void _throwAsIOE(Exception exception, String string, Object object) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string2 = object == null ? "[NULL]" : object.getClass().getName();
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing \"any\" property '").append(string);
            stringBuilder.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            stringBuilder.append("; actual type: ").append(string2).append(")");
            String string3 = exception.getMessage();
            if (string3 != null) {
                stringBuilder.append(", problem: ").append(string3);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(stringBuilder.toString(), null, exception);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throw new JsonMappingException(throwable.getMessage(), null, throwable);
    }

    private String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }
}

