/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;

public class ResourcePhaseListener
implements PhaseListener {
    public static final String RESOURCE_PREFIX = "/resource";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private Map<String, String> extensionToContentType = null;

    public ResourcePhaseListener() {
        this.init();
    }

    private void init() {
        this.extensionToContentType = new HashMap<String, String>();
        this.extensionToContentType.put(".js", "text/javascript");
        this.extensionToContentType.put(".gif", "image/gif");
        this.extensionToContentType.put(".jpg", "image/jpeg");
        this.extensionToContentType.put(".jpeg", "image/jpeg");
        this.extensionToContentType.put(".png", "image/png");
        this.extensionToContentType.put(".ico", "image/vnd.microsoft.icon");
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public void afterPhase(PhaseEvent event) {
        if (-1 != event.getFacesContext().getViewRoot().getViewId().indexOf(RESOURCE_PREFIX)) {
            this.renderResource(event);
        }
    }

    private String getResourceFromRequest(ExternalContext context) {
        String result = null;
        result = (String)context.getRequestParameterMap().get("r");
        return result;
    }

    private String getContentTypeFromRequest(ExternalContext context, String resourceName) {
        int i;
        String result = null;
        result = (String)context.getRequestMap().get("ct");
        if (null == result && null != resourceName && -1 != (i = resourceName.lastIndexOf("."))) {
            result = resourceName.substring(i);
            result = this.extensionToContentType.get(result);
        }
        if (null == result) {
            result = DEFAULT_CONTENT_TYPE;
        }
        return result;
    }

    private void renderResource(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        ExternalContext extContext = context.getExternalContext();
        String resourceName = this.getResourceFromRequest(extContext);
        if (null == resourceName) {
            return;
        }
        URL url = ResourcePhaseListener.class.getResource(resourceName);
        URLConnection conn = null;
        InputStream stream = null;
        BufferedReader bufReader = null;
        Object response = extContext.getResponse();
        RenderResponse renderResponse = null;
        HttpServletResponse servletResponse = null;
        OutputStreamWriter outWriter = null;
        String contentType = this.getContentTypeFromRequest(extContext, resourceName);
        String curLine = null;
        try {
            if (response instanceof HttpServletResponse) {
                servletResponse = (HttpServletResponse)response;
                outWriter = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), servletResponse.getCharacterEncoding());
                conn = url.openConnection();
                conn.setUseCaches(false);
                stream = conn.getInputStream();
                bufReader = new BufferedReader(new InputStreamReader(stream));
                servletResponse.setContentType(contentType);
                servletResponse.setStatus(200);
            } else if (response instanceof RenderResponse) {
                renderResponse = (RenderResponse)response;
                outWriter = new OutputStreamWriter(renderResponse.getPortletOutputStream(), renderResponse.getCharacterEncoding());
                conn = url.openConnection();
                conn.setUseCaches(false);
                stream = conn.getInputStream();
                bufReader = new BufferedReader(new InputStreamReader(stream));
                renderResponse.setContentType(contentType);
            }
            while (null != (curLine = bufReader.readLine())) {
                outWriter.write(curLine + "\n");
            }
            outWriter.flush();
            outWriter.close();
            event.getFacesContext().responseComplete();
        }
        catch (Exception e) {
            String message = null;
            message = "Can't load script file:" + url.toExternalForm();
        }
    }
}

