/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBContextFactory;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;
import javax.xml.bind.ServiceLoaderUtil;

class ContextFinder {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";
    private static final String JAXB_CONTEXT_FACTORY_DEPRECATED = "javax.xml.bind.context.factory";
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static ServiceLoaderUtil.ExceptionHandler<JAXBException> EXCEPTION_HANDLER;

    ContextFinder() {
    }

    private static Throwable handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        Throwable t = x.getTargetException();
        if (t != null) {
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            return t;
        }
        return x;
    }

    private static JAXBException handleClassCastException(Class originalType, Class targetType) {
        URL targetTypeURL = ContextFinder.which(targetType);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(originalType).getResource("javax/xml/bind/JAXBContext.class"), targetTypeURL));
    }

    static JAXBContext newInstance(String contextPath, String className, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            Class spFactory = ServiceLoaderUtil.safeLoadClass(className, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            return ContextFinder.newInstance(contextPath, spFactory, classLoader, properties);
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format("ContextFinder.ProviderNotFound", className), x);
        }
        catch (RuntimeException | JAXBException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", className, x), x);
        }
    }

    static JAXBContext newInstance(String contextPath, Class spFactory, ClassLoader classLoader, Map properties) throws JAXBException {
        try {
            Object obj;
            Method m2;
            Object context = null;
            try {
                m2 = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m2.invoke(obj, contextPath, classLoader, properties);
            }
            catch (NoSuchMethodException m2) {
                // empty catch block
            }
            if (context == null) {
                m2 = spFactory.getMethod("createContext", String.class, ClassLoader.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m2.invoke(obj, contextPath, classLoader);
            }
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (InvocationTargetException x) {
            Throwable e = ContextFinder.handleInvocationTargetException(x);
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, e), e);
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, x), x);
        }
    }

    private static Object instantiateProviderIfNecessary(final Class<?> implClass) throws JAXBException {
        try {
            if (JAXBContextFactory.class.isAssignableFrom(implClass)) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return implClass.newInstance();
                    }
                });
            }
            return null;
        }
        catch (PrivilegedActionException x) {
            Throwable e = x.getCause() == null ? x : x.getCause();
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", implClass, e), e);
        }
    }

    static JAXBContext newInstance(Class[] classes, Map properties, String className) throws JAXBException {
        Class spi;
        try {
            spi = ServiceLoaderUtil.safeLoadClass(className, PLATFORM_DEFAULT_FACTORY_CLASS, ContextFinder.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException(e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{className, ContextFinder.which(spi)});
        }
        return ContextFinder.newInstance(classes, properties, spi);
    }

    static JAXBContext newInstance(Class[] classes, Map properties, Class spFactory) throws JAXBException {
        try {
            Method m = spFactory.getMethod("createContext", Class[].class, Map.class);
            Object obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
            Object context = m.invoke(obj, classes, properties);
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new JAXBException(e);
        }
        catch (InvocationTargetException e) {
            Throwable x = ContextFinder.handleInvocationTargetException(e);
            throw new JAXBException(x);
        }
    }

    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        StringTokenizer packages = new StringTokenizer(contextPath, ":");
        if (!packages.hasMoreTokens()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (packages.hasMoreTokens()) {
            String factoryClassName = ContextFinder.classNameFromPackageProperties(classLoader, packages.nextToken(":").replace('.', '/'), factoryId, JAXB_CONTEXT_FACTORY_DEPRECATED);
            if (factoryClassName == null) continue;
            return ContextFinder.newInstance(contextPath, factoryClassName, classLoader, properties);
        }
        String factoryName = ContextFinder.classNameFromSystemProperties();
        if (factoryName != null) {
            return ContextFinder.newInstance(contextPath, factoryName, classLoader, properties);
        }
        JAXBContextFactory obj = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER);
        if (obj != null) {
            return obj.createContext(contextPath, classLoader, properties);
        }
        factoryName = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, classLoader);
        if (factoryName != null) {
            return ContextFinder.newInstance(contextPath, factoryName, classLoader, properties);
        }
        Class ctxFactory = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (ctxFactory != null) {
            return ContextFinder.newInstance(contextPath, ctxFactory, classLoader, properties);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(contextPath, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader, properties);
    }

    static JAXBContext find(Class<?>[] classes, Map<String, ?> properties) throws JAXBException {
        logger.fine("Searching jaxb.properties");
        for (Class<?> c : classes) {
            if (c.getPackage() == null) continue;
            String factoryClassName = ContextFinder.classNameFromPackageProperties(ContextFinder.getClassClassLoader(c), c.getPackage().getName().replace('.', '/'), "javax.xml.bind.JAXBContextFactory", JAXB_CONTEXT_FACTORY_DEPRECATED);
            if (factoryClassName == null) continue;
            return ContextFinder.newInstance((Class[])classes, properties, factoryClassName);
        }
        String factoryClassName = ContextFinder.classNameFromSystemProperties();
        if (factoryClassName != null) {
            return ContextFinder.newInstance((Class[])classes, properties, factoryClassName);
        }
        JAXBContextFactory factory = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER);
        if (factory != null) {
            return factory.createContext(classes, properties);
        }
        String className = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, ContextFinder.getContextClassLoader());
        if (className != null) {
            return ContextFinder.newInstance((Class[])classes, properties, className);
        }
        logger.fine("Trying to create the platform default provider");
        Class ctxFactoryClass = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (ctxFactoryClass != null) {
            return ContextFinder.newInstance((Class[])classes, properties, ctxFactoryClass);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((Class[])classes, properties, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static String classNameFromPackageProperties(ClassLoader classLoader, String packageName, String ... factoryIds) throws JAXBException {
        String resourceName = packageName + "/jaxb.properties";
        logger.log(Level.FINE, "Trying to locate {0}", resourceName);
        Properties props = ContextFinder.loadJAXBProperties(classLoader, resourceName);
        if (props != null) {
            for (String factoryId : factoryIds) {
                if (!props.containsKey(factoryId)) continue;
                return props.getProperty(factoryId);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", packageName, factoryIds[0]));
        }
        return null;
    }

    private static String classNameFromSystemProperties() throws JAXBException {
        String factoryClassName = ContextFinder.getSystemProperty("javax.xml.bind.JAXBContextFactory");
        if (factoryClassName != null) {
            return factoryClassName;
        }
        factoryClassName = ContextFinder.getDeprecatedSystemProperty(JAXB_CONTEXT_FACTORY_DEPRECATED);
        if (factoryClassName != null) {
            return factoryClassName;
        }
        factoryClassName = ContextFinder.getDeprecatedSystemProperty(JAXBContext.class.getName());
        if (factoryClassName != null) {
            return factoryClassName;
        }
        return null;
    }

    private static String getDeprecatedSystemProperty(String property) {
        String value = ContextFinder.getSystemProperty(property);
        if (value != null) {
            logger.log(Level.WARNING, "Using non-standard property: {0}. Property {1} should be used instead.", new Object[]{property, "javax.xml.bind.JAXBContextFactory"});
        }
        return value;
    }

    private static String getSystemProperty(String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new GetPropertyAction(property));
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
        return value;
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String propFileName) throws JAXBException {
        Properties props = null;
        try {
            URL url = classLoader == null ? ClassLoader.getSystemResource(propFileName) : classLoader.getResource(propFileName);
            if (url != null) {
                logger.log(Level.FINE, "loading props from {0}", url);
                props = new Properties();
                InputStream is = url.openStream();
                props.load(is);
                is.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Unable to load " + propFileName, ioe);
            throw new JAXBException(ioe.toString(), ioe);
        }
        return props;
    }

    static URL which(Class clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = ContextFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    static URL which(Class clazz) {
        return ContextFinder.which(clazz, ContextFinder.getClassClassLoader(clazz));
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getClassClassLoader(final Class c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    @Deprecated
    static String firstByServiceLoaderDeprecated(Class spiClass, ClassLoader classLoader) throws JAXBException {
        String jaxbContextFQCN = spiClass.getName();
        logger.fine("Searching META-INF/services");
        BufferedReader r = null;
        String resource = "META-INF/services/" + jaxbContextFQCN;
        try {
            InputStream resourceStream;
            InputStream inputStream = resourceStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(resource) : classLoader.getResourceAsStream(resource);
            if (resourceStream != null) {
                r = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                String factoryClassName = r.readLine();
                if (factoryClassName != null) {
                    factoryClassName = factoryClassName.trim();
                }
                r.close();
                logger.log(Level.FINE, "Configured factorty class:{0}", factoryClassName);
                String string = factoryClassName;
                return string;
            }
            logger.log(Level.FINE, "Unable to load:{0}", resource);
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Unable to close resource: " + resource, ex);
            }
        }
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<JAXBException>(){

            @Override
            public JAXBException createException(Throwable throwable, String message) {
                return new JAXBException(message, throwable);
            }
        };
    }
}

