/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.HeaderProvider;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderFactory {
    private static AtomicReference<ProviderFactory> pfr = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderFactory getInstance() {
        ProviderFactory pf = pfr.get();
        if (pf != null) {
            return pf;
        }
        AtomicReference<ProviderFactory> atomicReference = pfr;
        synchronized (atomicReference) {
            pf = pfr.get();
            if (pf != null) {
                return pf;
            }
            Iterator ps = Service.providers(ProviderFactory.class);
            if (ps.hasNext()) {
                pf = (ProviderFactory)ps.next();
                pfr.set(pf);
            }
        }
        return pf;
    }

    public abstract <T> T createInstance(Class<T> var1);

    public abstract <T> HeaderProvider<T> createHeaderProvider(Class<T> var1);

    public abstract <T> MessageBodyReader<T> createMessageBodyReader(Class<T> var1, MediaType var2);

    public abstract <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> var1, MediaType var2);
}

