/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.ApiMessages;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Contract;
import javax.ws.rs.ext.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    public abstract Object getEntity();

    public abstract int getStatus();

    public abstract MultivaluedMap<String, Object> getMetadata();

    public static Builder status(int status) {
        Builder b = Builder.newInstance();
        b.status(status);
        return b;
    }

    public static Builder ok() {
        Builder b = Builder.newInstance();
        b.status(200);
        return b;
    }

    public static Builder ok(Object entity) {
        Builder b = Response.ok();
        b.entity(entity);
        return b;
    }

    public static Builder ok(Object entity, MediaType type) {
        Builder b = Response.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static Builder ok(Object entity, String type) {
        Builder b = Response.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static Builder ok(Object entity, Variant variant) {
        Builder b = Response.ok();
        b.entity(entity);
        b.variant(variant);
        return b;
    }

    public static Builder serverError() {
        Builder b = Builder.newInstance();
        b.status(500);
        return b;
    }

    public static Builder created(URI location) {
        Builder b = Builder.newInstance();
        b.status(201).location(location);
        return b;
    }

    public static Builder noContent() {
        Builder b = Builder.newInstance();
        b.status(204);
        return b;
    }

    public static Builder notModified() {
        Builder b = Builder.newInstance();
        b.status(304);
        return b;
    }

    public static Builder notModified(EntityTag tag) {
        Builder b = Response.notModified();
        b.tag(tag);
        return b;
    }

    public static Builder notModified(String tag) {
        Builder b = Response.notModified();
        b.tag(tag);
        return b;
    }

    public static Builder temporaryRedirect(URI location) {
        Builder b = Builder.newInstance();
        b.status(307).location(location);
        return b;
    }

    public static Builder notAcceptable(List<Variant> variants) {
        Builder b = Builder.newInstance();
        b.status(406).variants(variants);
        return b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Contract
    public static abstract class Builder {
        protected static synchronized Builder newInstance() {
            Builder b = ProviderFactory.getInstance().createInstance(Builder.class);
            if (b == null) {
                throw new UnsupportedOperationException(ApiMessages.NO_BUILDER_IMPL());
            }
            return b;
        }

        public abstract Response build();

        public abstract Builder status(int var1);

        public abstract Builder entity(Object var1);

        public abstract Builder type(MediaType var1);

        public abstract Builder type(String var1);

        public abstract Builder variant(Variant var1);

        public abstract Builder variants(List<Variant> var1);

        public abstract Builder language(String var1);

        public abstract Builder location(URI var1);

        public abstract Builder contentLocation(URI var1);

        public abstract Builder tag(EntityTag var1);

        public abstract Builder tag(String var1);

        public abstract Builder lastModified(Date var1);

        public abstract Builder cacheControl(CacheControl var1);

        public abstract Builder header(String var1, Object var2);

        public abstract Builder cookie(NewCookie var1);
    }
}

