/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.net.URI;
import java.util.Date;
import javax.ws.rs.core.ApiMessages;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.Contract;
import javax.ws.rs.ext.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Response {
    public Object getEntity();

    public int getStatus();

    public void addMetadata(MultivaluedMap<String, Object> var1);

    @Contract
    public static abstract class Builder {
        protected static synchronized Builder newInstance() {
            Builder b = ProviderFactory.getInstance().createInstance(Builder.class);
            if (b == null) {
                throw new UnsupportedOperationException(ApiMessages.NO_BUILDER_IMPL());
            }
            return b;
        }

        public abstract Response build();

        public static Builder representation(Object entity) {
            Builder b = Builder.newInstance();
            b.status(200).entity(entity);
            return b;
        }

        public static Builder representation(Object entity, MediaType type) {
            Builder b = Builder.representation(entity);
            b.type(type);
            return b;
        }

        public static Builder representation(Object entity, String type) {
            Builder b = Builder.representation(entity);
            b.type(type);
            return b;
        }

        public static Builder ok() {
            Builder b = Builder.newInstance();
            b.status(200);
            return b;
        }

        public static Builder ok(Object entity) {
            Builder b = Builder.ok();
            b.entity(entity);
            return b;
        }

        public static Builder serverError() {
            Builder b = Builder.newInstance();
            b.status(500);
            return b;
        }

        public static Builder created(Object entity, URI location) {
            Builder b = Builder.created(location);
            b.entity(entity);
            return b;
        }

        public static Builder created(URI location) {
            Builder b = Builder.newInstance();
            b.status(201).location(location);
            return b;
        }

        public static Builder noContent() {
            Builder b = Builder.newInstance();
            b.status(204);
            return b;
        }

        public static Builder notModified() {
            Builder b = Builder.newInstance();
            b.status(304);
            return b;
        }

        public static Builder notModified(EntityTag tag) {
            Builder b = Builder.notModified();
            b.tag(tag);
            return b;
        }

        public static Builder notModified(String tag) {
            Builder b = Builder.notModified();
            b.tag(tag);
            return b;
        }

        public static Builder temporaryRedirect(URI location) {
            Builder b = Builder.newInstance();
            b.status(307).location(location);
            return b;
        }

        public abstract Builder status(int var1);

        public abstract Builder entity(Object var1);

        public abstract Builder type(MediaType var1);

        public abstract Builder type(String var1);

        public abstract Builder language(String var1);

        public abstract Builder location(URI var1);

        public abstract Builder contentLocation(URI var1);

        public abstract Builder tag(EntityTag var1);

        public abstract Builder tag(String var1);

        public abstract Builder lastModified(Date var1);

        public abstract Builder cacheControl(CacheControl var1);

        public abstract Builder header(String var1, Object var2);

        public abstract Builder cookie(NewCookie var1);
    }
}

