/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.client;

import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.FactoryFinder;

public abstract class ClientFactory {
    public static final String JAXRS_DEFAULT_CLIENT_FACTORY_PROPERTY = "javax.ws.rs.ext.ClientFactory";
    private static final String JAXRS_DEFAULT_CLIENT_FACTORY = "org.glassfish.jersey.client.JerseyClientFactory";

    protected ClientFactory() {
    }

    private static ClientFactory getFactory() {
        try {
            Object delegate = FactoryFinder.find(JAXRS_DEFAULT_CLIENT_FACTORY_PROPERTY, JAXRS_DEFAULT_CLIENT_FACTORY);
            if (!(delegate instanceof ClientFactory)) {
                Class<ClientFactory> pClass = ClientFactory.class;
                String classnameAsResource = pClass.getName().replace('.', '/') + ".class";
                ClassLoader loader = pClass.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                URL targetTypeURL = loader.getResource(classnameAsResource);
                throw new LinkageError("ClassCastException: attempting to cast" + delegate.getClass().getClassLoader().getResource(classnameAsResource) + " to " + targetTypeURL);
            }
            return (ClientFactory)delegate;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Client newClient() {
        return ClientFactory.getFactory().getClient();
    }

    public static Client newClient(Configuration configuration) {
        return ClientFactory.getFactory().getClient(configuration);
    }

    protected abstract Client getClient();

    protected abstract Client getClient(Configuration var1);
}

