/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

public class WebConfiguration {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.config");
    private static final Pattern ALLOWABLE_BOOLEANS = Pattern.compile("true|false");
    private static final String WEB_CONFIG_KEY = "com.sun.faces.config.WebConfiguration";
    private Map<BooleanWebContextInitParameter, Boolean> booleanContextParameters = new HashMap<BooleanWebContextInitParameter, Boolean>(BooleanWebContextInitParameter.values().length);
    private Map<WebContextInitParameter, String> contextParameters = new HashMap<WebContextInitParameter, String>(WebContextInitParameter.values().length);
    private Map<WebEnvironmentEntry, String> envEntries = new HashMap<WebEnvironmentEntry, String>(WebEnvironmentEntry.values().length);
    private ServletContext servletContext;

    /*
     * WARNING - void declaration
     */
    private WebConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
        String contextName = this.getServletContextName();
        for (WebContextInitParameter webContextInitParameter : WebContextInitParameter.values()) {
            String value = servletContext.getInitParameter(webContextInitParameter.getQualifiedName());
            if (value != null && value.length() > 0 && webContextInitParameter.isDeprecated()) {
                WebContextInitParameter alternate = webContextInitParameter.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, webContextInitParameter.getQualifiedName(), alternate.getQualifiedName()});
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.webconfig.configinfo.reset", new Object[]{contextName, alternate.getQualifiedName(), value});
                }
                this.contextParameters.put(alternate, value);
                continue;
            }
            if (value != null && value.length() != 0 || webContextInitParameter.isDeprecated()) continue;
            value = webContextInitParameter.getDefaultValue();
            if (value.length() > 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.webconfig.configinfo", new Object[]{contextName, webContextInitParameter.getQualifiedName(), value});
                }
                this.contextParameters.put(webContextInitParameter, value);
                continue;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.log(Level.INFO, "jsf.config.webconfig.option.notconfigured", new Object[]{contextName, webContextInitParameter.getQualifiedName()});
        }
        for (Enum enum_ : BooleanWebContextInitParameter.values()) {
            boolean value;
            String strValue = servletContext.getInitParameter(((BooleanWebContextInitParameter)enum_).getQualifiedName());
            if (strValue != null && strValue.length() > 0 && ((BooleanWebContextInitParameter)enum_).isDeprecated()) {
                BooleanWebContextInitParameter alternate = ((BooleanWebContextInitParameter)enum_).getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, ((BooleanWebContextInitParameter)enum_).getQualifiedName(), alternate.getQualifiedName()});
                }
                value = this.isValueValid((BooleanWebContextInitParameter)enum_, strValue) ? Boolean.valueOf(strValue).booleanValue() : ((BooleanWebContextInitParameter)enum_).getDefaultValue();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, value ? "jsf.config.webconfig.configinfo.reset.enabled" : "jsf.config.webconfig.configinfo.reset.disabled", new Object[]{contextName, ((BooleanWebContextInitParameter)enum_).getQualifiedName()});
                }
                this.booleanContextParameters.put(alternate, value);
                continue;
            }
            if (((BooleanWebContextInitParameter)enum_).isDeprecated()) continue;
            value = strValue == null ? ((BooleanWebContextInitParameter)enum_).getDefaultValue() : (this.isValueValid((BooleanWebContextInitParameter)enum_, strValue) ? Boolean.valueOf(strValue).booleanValue() : ((BooleanWebContextInitParameter)enum_).getDefaultValue());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, value ? "jsf.config.webconfig.boolconfiginfo.enabled" : "jsf.config.webconfig.boolconfiginfo.disabled", new Object[]{contextName, ((BooleanWebContextInitParameter)enum_).getQualifiedName()});
            }
            this.booleanContextParameters.put((BooleanWebContextInitParameter)enum_, value);
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (initialContext != null) {
            void var6_12;
            WebEnvironmentEntry[] arr$ = WebEnvironmentEntry.values();
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_12 < len$) {
                WebEnvironmentEntry entry = arr$[var6_12];
                String entryName = entry.getQualifiedName();
                try {
                    String value = (String)initialContext.lookup(entryName);
                    if (value != null) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            if (!entry.equals((Object)WebEnvironmentEntry.ClientStateSavingPassword)) {
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, "jsf.config.webconfig.enventryinfo", new Object[]{contextName, entryName, value});
                                }
                            } else if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, "jsf.config.webconfig.enventry.clientencrypt", contextName);
                            }
                        }
                        this.envEntries.put(entry, value);
                    }
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                ++var6_12;
            }
        }
    }

    public static WebConfiguration getInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        return WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public static WebConfiguration getInstance(ExternalContext extContext) {
        return (WebConfiguration)extContext.getApplicationMap().get(WEB_CONFIG_KEY);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletContextName() {
        if (this.servletContext.getMajorVersion() == 2 && this.servletContext.getMinorVersion() <= 4) {
            return this.servletContext.getServletContextName();
        }
        return this.servletContext.getContextPath();
    }

    public boolean getBooleanContextInitParameter(BooleanWebContextInitParameter param) {
        return this.booleanContextParameters.get((Object)param);
    }

    public String getEnvironmentEntry(WebEnvironmentEntry entry) {
        return this.envEntries.get((Object)entry);
    }

    public String getContextInitParameter(WebContextInitParameter param) {
        return this.contextParameters.get((Object)param);
    }

    public void overrideContextInitParameter(WebContextInitParameter param) {
    }

    public void overrideContextInitParameter(BooleanWebContextInitParameter param) {
    }

    public void overrideEnvEntry(WebEnvironmentEntry entry) {
    }

    static void clear(ServletContext servletContext) {
        servletContext.removeAttribute(WEB_CONFIG_KEY);
    }

    static WebConfiguration getInstance(ServletContext servletContext) {
        WebConfiguration webConfig = (WebConfiguration)servletContext.getAttribute(WEB_CONFIG_KEY);
        if (webConfig == null) {
            webConfig = new WebConfiguration(servletContext);
            servletContext.setAttribute(WEB_CONFIG_KEY, (Object)webConfig);
        }
        return webConfig;
    }

    private boolean isValueValid(BooleanWebContextInitParameter param, String value) {
        if (!ALLOWABLE_BOOLEANS.matcher(value).matches()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.config.webconfig.boolconfig.invalidvalue", new Object[]{value, param.getQualifiedName(), "true|false"});
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebEnvironmentEntry {
        ClientStateSavingPassword("ClientStateSavingPassword");

        private static final String JNDI_PREFIX = "java:comp/env/";
        private String qualifiedName;

        private WebEnvironmentEntry(String qualifiedName) {
            this.qualifiedName = "java:comp/env/com.sun.faces." + qualifiedName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanWebContextInitParameter {
        ValidateFacesConfigFiles("validateXml", false),
        VerifyFacesConfigObjects("verifyObjects", false),
        ForceLoadFacesConfigFiles("forceLoadConfiguration", false),
        DisableArtifactVersioning("disableVersionTracking", false),
        EnableHtmlTagLibraryValidator("enableHtmlTagLibValidator", false),
        PreferXHTMLContentType("preferXHTML", false),
        PreferXHTMLContextTypeDeprecated("PreferXHTML", false, true, PreferXHTMLContentType),
        CompressViewState("compressViewState", true),
        CompressViewStateDeprecated("COMPRESS_STATE", true, true, CompressViewState);

        private BooleanWebContextInitParameter alternate;
        private String qualifiedName;
        private boolean defaultValue;
        private boolean deprecated;

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue, boolean deprecated, BooleanWebContextInitParameter alternate) {
            this.qualifiedName = "com.sun.faces." + qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private BooleanWebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebContextInitParameter {
        ManagedBeanFactoryDecorator("managedBeanFactoryDecoratorClass", ""),
        StateSavingMethod("STATE_SAVING_METHOD", "server"),
        JspDefaultSuffix("DEFAULT_SUFFIX", ".jsp"),
        JavaxFacesConfigFiles("CONFIG_FILES", ""),
        AlternateLifecycleId("LIFECYCLE_ID", ""),
        NumberOfViews("numberOfViewsInSession", "15"),
        NumberOfViewsDeprecated("NUMBER_OF_VIEWS_IN_SESSION", "15", true, NumberOfViews),
        NumberOfLogicalViews("numberOfLogicalViews", "15"),
        NumberOfLogicalViewsDeprecated("NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION", "15", true, NumberOfLogicalViews);

        private String defaultValue;
        private String qualifiedName;
        private WebContextInitParameter alternate;
        private boolean deprecated;

        private WebContextInitParameter(String qualifiedName, String defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue, boolean deprecated, WebContextInitParameter alternate) {
            this.qualifiedName = "com.sun.faces." + qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

