/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.renderkit.ApplicationObjectInputStream;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.util.Base64;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private static final Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    private static final String FACES_VIEW_STATE = "com.sun.faces.FACES_VIEW_STATE";
    private static final String COMPRESS_STATE_PARAM = "com.sun.faces.COMPRESS_STATE";
    private Boolean compressStateSet = null;
    private ByteArrayGuard byteArrayGuard = ByteArrayGuard.getInstance();

    public Object getComponentStateToRestore(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object state = requestMap.get(FACES_VIEW_STATE);
        requestMap.remove(FACES_VIEW_STATE);
        return state;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("javax.faces.ViewState");
    }

    public Object getState(FacesContext context, String viewId) {
        return super.getState(context, viewId);
    }

    public Object getTreeStructureToRestore(FacesContext context, String treeId) {
        StateManager stateManager = Util.getStateManager(context);
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String viewString = (String)requestParamMap.get("javax.faces.ViewState");
        Object structure = null;
        if (viewString == null) {
            return null;
        }
        if (stateManager.isSavingStateInClient(context)) {
            Object state = null;
            ByteArrayInputStream bis = null;
            GZIPInputStream gis = null;
            ApplicationObjectInputStream ois = null;
            boolean compress = this.isCompressStateSet(context);
            try {
                byte[] bytes = this.byteArrayGuard.decrypt(Base64.decode(viewString.getBytes()));
                bis = new ByteArrayInputStream(bytes);
                if (this.isCompressStateSet(context)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Deflating state before restoring..");
                    }
                    gis = new GZIPInputStream(bis);
                    ois = new ApplicationObjectInputStream(gis);
                } else {
                    ois = new ApplicationObjectInputStream(bis);
                }
                structure = ois.readObject();
                state = ois.readObject();
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(FACES_VIEW_STATE, state);
                bis.close();
                if (compress) {
                    gis.close();
                }
                ois.close();
            }
            catch (OptionalDataException ode) {
                logger.log(Level.SEVERE, ode.getMessage(), ode);
                throw new FacesException((Throwable)ode);
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(Level.SEVERE, cnfe.getMessage(), cnfe);
                throw new FacesException((Throwable)cnfe);
            }
            catch (IOException iox) {
                logger.log(Level.SEVERE, iox.getMessage(), iox);
                throw new FacesException((Throwable)iox);
            }
        } else {
            structure = viewString;
        }
        return structure;
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        StateManager stateManager = Util.getStateManager(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)context.getViewRoot());
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"javax.faces.ViewState", null);
        writer.writeAttribute("id", (Object)"javax.faces.ViewState", null);
        if (stateManager.isSavingStateInClient(context)) {
            GZIPOutputStream zos = null;
            ObjectOutputStream oos = null;
            boolean compress = this.isCompressStateSet(context);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (compress) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Compressing state before saving..");
                }
                zos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream(zos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(view.getStructure());
            oos.writeObject(view.getState());
            oos.close();
            if (compress) {
                zos.close();
            }
            byte[] securedata = this.byteArrayGuard.encrypt(bos.toByteArray());
            bos.close();
            String valueToWrite = new String(Base64.encode(securedata), "ISO-8859-1");
            writer.writeAttribute("value", (Object)valueToWrite, null);
        } else {
            writer.writeAttribute("value", view.getStructure(), null);
        }
        writer.endElement("input");
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !result.equals("HTML_BASIC")) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)"HTML_BASIC", "value");
            writer.endElement("input");
        }
    }

    private boolean isCompressStateSet(FacesContext context) {
        if (null != this.compressStateSet) {
            return this.compressStateSet;
        }
        this.compressStateSet = Boolean.TRUE;
        String compressStateParam = context.getExternalContext().getInitParameter(COMPRESS_STATE_PARAM);
        if (compressStateParam != null) {
            this.compressStateSet = Boolean.valueOf(compressStateParam);
        }
        return this.compressStateSet;
    }
}

