/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseContextMap
extends AbstractMap {
    private Set<? extends Object> entrySet;
    private Set<? extends Object> keySet;
    private Collection<? extends Object> values;

    BaseContextMap() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Object> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<? extends Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<? extends Object> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeKey(String key) {
        return this.remove(key) != null;
    }

    protected boolean removeValue(Object value) {
        boolean valueRemoved = false;
        if (value == null) {
            return false;
        }
        if (this.containsValue(value)) {
            for (Map.Entry entry : this.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                valueRemoved = this.remove(entry.getKey()) != null;
            }
        }
        return valueRemoved;
    }

    protected abstract Iterator getEntryIterator();

    protected abstract Iterator getKeyIterator();

    protected abstract Iterator getValueIterator();

    static class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry input = (Map.Entry)obj;
            Object inputKey = input.getKey();
            Object inputValue = input.getValue();
            return (inputKey == this.key || inputKey != null && inputKey.equals(this.key)) && (inputValue == this.value || inputValue != null && inputValue.equals(this.value));
        }
    }

    class ValueIterator
    extends BaseIterator {
        ValueIterator(Enumeration e) {
            super(e);
        }

        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeValue(BaseContextMap.this.get(this.currentKey));
        }

        public Object next() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return BaseContextMap.this.get(this.currentKey);
        }
    }

    class KeyIterator
    extends BaseIterator {
        KeyIterator(Enumeration e) {
            super(e);
        }

        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        public Object next() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return this.currentKey;
        }
    }

    class EntryIterator
    extends BaseIterator {
        EntryIterator(Enumeration e) {
            super(e);
        }

        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        public Object next() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return new Entry(this.currentKey, BaseContextMap.this.get(this.currentKey));
        }
    }

    abstract class BaseIterator
    implements Iterator {
        protected Enumeration e;
        protected String currentKey;
        protected boolean removeCalled = false;

        BaseIterator(Enumeration e) {
            this.e = e;
        }

        public boolean hasNext() {
            return this.e.hasMoreElements();
        }
    }

    class ValueCollection
    extends AbstractCollection {
        ValueCollection() {
        }

        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }

        public Iterator iterator() {
            return BaseContextMap.this.getValueIterator();
        }

        public boolean remove(Object o) {
            return BaseContextMap.this.removeValue(o);
        }
    }

    class KeySet
    extends BaseSet {
        KeySet() {
        }

        public Iterator iterator() {
            return BaseContextMap.this.getKeyIterator();
        }

        public boolean remove(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            return BaseContextMap.this.removeKey((String)o);
        }
    }

    class EntrySet
    extends BaseSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return BaseContextMap.this.getEntryIterator();
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return BaseContextMap.this.removeKey((String)((Map.Entry)o).getKey());
        }
    }

    abstract class BaseSet
    extends AbstractSet {
        BaseSet() {
        }

        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }
    }
}

