/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2DoubleMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSortedSet;
import it.unimi.dsi.fastutil.floats.Float2DoubleSortedMap;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloat2DoubleSortedMap
extends AbstractFloat2DoubleMap
implements Float2DoubleSortedMap {
    public static final long serialVersionUID = -1773560792952436569L;

    protected AbstractFloat2DoubleSortedMap() {
    }

    @Override
    public Float2DoubleSortedMap headMap(Float to) {
        return this.headMap(to.floatValue());
    }

    @Override
    public Float2DoubleSortedMap tailMap(Float from) {
        return this.tailMap(from.floatValue());
    }

    @Override
    public Float2DoubleSortedMap subMap(Float from, Float to) {
        return this.subMap(from.floatValue(), to.floatValue());
    }

    @Override
    public Float firstKey() {
        return Float.valueOf(this.firstFloatKey());
    }

    @Override
    public Float lastKey() {
        return Float.valueOf(this.lastFloatKey());
    }

    @Override
    public FloatSortedSet keySet() {
        return new KeySet();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesCollection();
    }

    @Override
    public ObjectSortedSet<Map.Entry<Float, Double>> entrySet() {
        return this.float2DoubleEntrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ValuesIterator
    extends AbstractDoubleIterator {
        protected final ObjectBidirectionalIterator<Map.Entry<Float, Double>> i;

        public ValuesIterator(ObjectBidirectionalIterator<Map.Entry<Float, Double>> i) {
            this.i = i;
        }

        @Override
        public double nextDouble() {
            return (Double)((Map.Entry)this.i.next()).getValue();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }
    }

    protected class ValuesCollection
    extends AbstractDoubleCollection {
        protected ValuesCollection() {
        }

        public DoubleIterator iterator() {
            return new ValuesIterator(AbstractFloat2DoubleSortedMap.this.entrySet().iterator());
        }

        public boolean contains(double k) {
            return AbstractFloat2DoubleSortedMap.this.containsValue(k);
        }

        public int size() {
            return AbstractFloat2DoubleSortedMap.this.size();
        }

        public void clear() {
            AbstractFloat2DoubleSortedMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class KeySetIterator
    extends AbstractFloatBidirectionalIterator {
        protected final ObjectBidirectionalIterator<Map.Entry<Float, Double>> i;

        public KeySetIterator(ObjectBidirectionalIterator<Map.Entry<Float, Double>> i) {
            this.i = i;
        }

        @Override
        public float nextFloat() {
            return ((Float)((Map.Entry)this.i.next()).getKey()).floatValue();
        }

        @Override
        public float previousFloat() {
            return ((Float)((Map.Entry)this.i.previous()).getKey()).floatValue();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }
    }

    protected class KeySet
    extends AbstractFloatSortedSet {
        protected KeySet() {
        }

        public boolean contains(float k) {
            return AbstractFloat2DoubleSortedMap.this.containsKey(k);
        }

        public int size() {
            return AbstractFloat2DoubleSortedMap.this.size();
        }

        public void clear() {
            AbstractFloat2DoubleSortedMap.this.clear();
        }

        public FloatComparator comparator() {
            return AbstractFloat2DoubleSortedMap.this.comparator();
        }

        public float firstFloat() {
            return AbstractFloat2DoubleSortedMap.this.firstFloatKey();
        }

        public float lastFloat() {
            return AbstractFloat2DoubleSortedMap.this.lastFloatKey();
        }

        public FloatSortedSet headSet(float to) {
            return AbstractFloat2DoubleSortedMap.this.headMap(to).keySet();
        }

        public FloatSortedSet tailSet(float from) {
            return AbstractFloat2DoubleSortedMap.this.tailMap(from).keySet();
        }

        public FloatSortedSet subSet(float from, float to) {
            return AbstractFloat2DoubleSortedMap.this.subMap(from, to).keySet();
        }

        public FloatBidirectionalIterator iterator(float from) {
            return new KeySetIterator(AbstractFloat2DoubleSortedMap.this.entrySet().iterator(new AbstractFloat2DoubleMap.BasicEntry(from, 0.0)));
        }

        public FloatBidirectionalIterator iterator() {
            return new KeySetIterator(AbstractFloat2DoubleSortedMap.this.entrySet().iterator());
        }
    }
}

