/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharHash;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharOpenCustomHashSet
extends AbstractCharSet
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient char[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected CharHash.Strategy strategy;

    public CharOpenCustomHashSet(int expected, float f, CharHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new char[this.n];
        this.used = new boolean[this.n];
    }

    public CharOpenCustomHashSet(int expected, CharHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(CharHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(Collection<? extends Character> c, float f, CharHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public CharOpenCustomHashSet(Collection<? extends Character> c, CharHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(CharCollection c, float f, CharHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public CharOpenCustomHashSet(CharCollection c, CharHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(CharIterator i, float f, CharHash.Strategy strategy) {
        this(16, f, strategy);
        while (i.hasNext()) {
            this.add(i.nextChar());
        }
    }

    public CharOpenCustomHashSet(CharIterator i, CharHash.Strategy strategy) {
        this(i, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(Iterator<?> i, float f, CharHash.Strategy strategy) {
        this(CharIterators.asCharIterator(i), f, strategy);
    }

    public CharOpenCustomHashSet(Iterator<?> i, CharHash.Strategy strategy) {
        this(CharIterators.asCharIterator(i), strategy);
    }

    public CharOpenCustomHashSet(char[] a, int offset, int length, float f, CharHash.Strategy strategy) {
        this(length < 0 ? 0 : length, f, strategy);
        CharArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public CharOpenCustomHashSet(char[] a, int offset, int length, CharHash.Strategy strategy) {
        this(a, offset, length, 0.75f, strategy);
    }

    public CharOpenCustomHashSet(char[] a, float f, CharHash.Strategy strategy) {
        this(a, 0, a.length, f, strategy);
    }

    public CharOpenCustomHashSet(char[] a, CharHash.Strategy strategy) {
        this(a, 0.75f, strategy);
    }

    public CharHash.Strategy strategy() {
        return this.strategy;
    }

    @Override
    public boolean add(char k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.strategy.hashCode(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public boolean remove(char k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(char k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    @Override
    public CharIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        char[] key = this.key;
        int newMask = newN - 1;
        char[] newKey = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            char k = key[i];
            int pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
    }

    public CharOpenCustomHashSet clone() {
        CharOpenCustomHashSet c;
        try {
            c = (CharOpenCustomHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (char[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += this.strategy.hashCode(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        CharIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeChar(i.nextChar());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new char[this.n];
        char[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            char k = s.readChar();
            pos = HashCommon.murmurHash3(this.strategy.hashCode(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractCharIterator {
        int pos;
        int last;
        int c;

        private SetIterator() {
            this.pos = CharOpenCustomHashSet.this.n;
            this.last = -1;
            this.c = CharOpenCustomHashSet.this.size;
            boolean[] used = CharOpenCustomHashSet.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            char retVal = CharOpenCustomHashSet.this.key[this.last];
            if (--this.c != 0) {
                boolean[] used = CharOpenCustomHashSet.this.used;
                while (!used[this.pos = this.pos - 1 & CharOpenCustomHashSet.this.mask]) {
                }
            }
            return retVal;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --CharOpenCustomHashSet.this.size;
            if (CharOpenCustomHashSet.this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextChar();
            }
            this.last = -1;
        }
    }
}

