/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharBigList;
import it.unimi.dsi.fastutil.chars.AbstractCharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.chars.CharBigList;
import it.unimi.dsi.fastutil.chars.CharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharBigArrayBigList
extends AbstractCharBigList
implements RandomAccess,
Cloneable,
Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected transient char[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected CharBigArrayBigList(char[][] a, boolean dummy) {
        this.a = a;
    }

    public CharBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = CharBigArrays.newBigArray(capacity);
    }

    public CharBigArrayBigList() {
        this(16L);
    }

    public CharBigArrayBigList(CharCollection c) {
        this(c.size());
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.nextChar());
        }
    }

    public CharBigArrayBigList(CharBigList l) {
        this(l.size64());
        this.size = l.size64();
        l.getElements(0L, this.a, 0L, this.size);
    }

    public CharBigArrayBigList(char[][] a) {
        this(a, 0L, CharBigArrays.length(a));
    }

    public CharBigArrayBigList(char[][] a, long offset, long length) {
        this(length);
        CharBigArrays.copy(a, offset, this.a, 0L, length);
        this.size = length;
    }

    public CharBigArrayBigList(Iterator<? extends Character> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public CharBigArrayBigList(CharIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextChar());
        }
    }

    public char[][] elements() {
        return this.a;
    }

    public static CharBigArrayBigList wrap(char[][] a, long length) {
        if (length > CharBigArrays.length(a)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + CharBigArrays.length(a) + ")");
        }
        CharBigArrayBigList l = new CharBigArrayBigList(a, false);
        l.size = length;
        return l;
    }

    public static CharBigArrayBigList wrap(char[][] a) {
        return CharBigArrayBigList.wrap(a, CharBigArrays.length(a));
    }

    public void ensureCapacity(long capacity) {
        this.a = CharBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = CharBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, char k) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            CharBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        CharBigArrays.set(this.a, index, k);
        ++this.size;
    }

    @Override
    public boolean add(char k) {
        this.grow(this.size + 1L);
        CharBigArrays.set(this.a, this.size++, k);
        return true;
    }

    @Override
    public char getChar(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return CharBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(char k) {
        for (long i = 0L; i < this.size; ++i) {
            if (k != CharBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(char k) {
        long i = this.size;
        while (i-- != 0L) {
            if (k != CharBigArrays.get(this.a, i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public char removeChar(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = CharBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            CharBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(char k) {
        long index = this.indexOf(k);
        if (index == -1L) {
            return false;
        }
        this.removeChar(index);
        return true;
    }

    @Override
    public char set(long index, char k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = CharBigArrays.get(this.a, index);
        CharBigArrays.set(this.a, index, k);
        return old;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > CharBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            CharBigArrays.fill(this.a, this.size, size, '\u0000');
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n) {
        long arrayLength = CharBigArrays.length(this.a);
        if (n >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = CharBigArrays.trim(this.a, Math.max(n, this.size));
    }

    public void getElements(int from, char[][] a, long offset, long length) {
        CharBigArrays.copy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        BigArrays.ensureFromTo(this.size, from, to);
        CharBigArrays.copy(this.a, to, this.a, from, this.size - (long)to);
        this.size -= (long)(to - from);
    }

    public void addElements(int index, char[][] a, long offset, long length) {
        this.ensureIndex(index);
        CharBigArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        CharBigArrays.copy(this.a, index, this.a, (long)index + length, this.size - (long)index);
        CharBigArrays.copy(a, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public CharBigListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractCharBigListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return (long)this.pos < CharBigArrayBigList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return CharBigArrays.get(CharBigArrayBigList.this.a, this.last);
            }

            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return CharBigArrays.get(CharBigArrayBigList.this.a, this.pos);
            }

            public long nextIndex() {
                return this.pos;
            }

            public long previousIndex() {
                return this.pos - 1;
            }

            public void add(char k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharBigArrayBigList.this.add((long)this.pos++, k);
                this.last = -1;
            }

            public void set(char k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharBigArrayBigList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharBigArrayBigList.this.removeChar(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public CharBigArrayBigList clone() {
        CharBigArrayBigList c = new CharBigArrayBigList(this.size);
        CharBigArrays.copy(this.a, 0L, c.a, 0L, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(CharBigArrayBigList l) {
        if (l == this) {
            return true;
        }
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        char[][] a1 = this.a;
        char[][] a2 = l.a;
        while (s-- != 0L) {
            if (CharBigArrays.get(a1, s) == CharBigArrays.get(a2, s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CharBigArrayBigList l) {
        long s1 = this.size64();
        long s2 = l.size64();
        char[][] a1 = this.a;
        char[][] a2 = l.a;
        int i = 0;
        while ((long)i < s1 && (long)i < s2) {
            int r;
            char e2;
            char e1 = CharBigArrays.get(a1, i);
            if ((e1 < (e2 = CharBigArrays.get(a2, i)) ? -1 : (r = e1 == e2 ? 0 : 1)) != 0) {
                return r;
            }
            ++i;
        }
        return (long)i < s2 ? -1 : ((long)i < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = 0;
        while ((long)i < this.size) {
            s.writeChar(CharBigArrays.get(this.a, i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = CharBigArrays.newBigArray(this.size);
        int i = 0;
        while ((long)i < this.size) {
            CharBigArrays.set(this.a, i, s.readChar());
            ++i;
        }
    }
}

