/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import java.io.Serializable;

@Deprecated
public class IntHyperLogLogCounterArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    public static final int CHUNK_SHIFT = 30;
    public static final long CHUNK_SIZE = 0x40000000L;
    public static final long CHUNK_MASK = 0x3FFFFFFFL;
    protected final LongArrayBitVector[] bitVector;
    protected final LongBigList[] registers;
    protected final int log2m;
    protected final int m;
    protected final int mMinus1;
    protected final int registerSize;
    protected final int counterSize;
    protected final int counterShift;
    protected long seed;
    private double alphaMM;
    private long sentinelMask;

    public static int log2NumberOfRegisters(double rsd) {
        return (int)Math.ceil(Fast.log2(1.106 / rsd * (1.106 / rsd)));
    }

    public static double relativeStandardDeviation(int log2m) {
        return (log2m == 4 ? 1.106 : (log2m == 5 ? 1.07 : (log2m == 6 ? 1.054 : (log2m == 7 ? 1.046 : 1.04)))) / Math.sqrt(1 << log2m);
    }

    public static int registerSize(long n) {
        return Math.max(5, (int)Math.ceil(Math.log(Math.log(n) / Math.log(2.0)) / Math.log(2.0)));
    }

    protected int chunk(int counter) {
        return counter >>> this.counterShift;
    }

    protected long offset(int counter) {
        return ((long)counter << this.log2m & 0x3FFFFFFFL) * (long)this.registerSize;
    }

    public IntHyperLogLogCounterArray(int arraySize, long n, double rsd) {
        this(arraySize, n, IntHyperLogLogCounterArray.log2NumberOfRegisters(rsd));
    }

    public IntHyperLogLogCounterArray(int arraySize, long n, int log2m) {
        this(arraySize, n, log2m, Util.randomSeed());
    }

    public IntHyperLogLogCounterArray(int arraySize, long n, int log2m, long seed) {
        this.log2m = log2m;
        this.m = 1 << this.log2m;
        this.mMinus1 = this.m - 1;
        this.registerSize = IntHyperLogLogCounterArray.registerSize(n);
        this.counterSize = this.registerSize << log2m;
        this.counterShift = 30 - log2m;
        this.sentinelMask = 1L << (1 << this.registerSize) - 2;
        long sizeInRegisters = (long)arraySize * (long)this.m;
        int numVectors = (int)(sizeInRegisters + 0x3FFFFFFFL >>> 30);
        this.bitVector = new LongArrayBitVector[numVectors];
        this.registers = new LongBigList[numVectors];
        for (int i = 0; i < numVectors; ++i) {
            this.bitVector[i] = LongArrayBitVector.ofLength((long)this.registerSize * Math.min(0x40000000L, sizeInRegisters - ((long)i << 30)));
            this.registers[i] = this.bitVector[i].asLongBigList(this.registerSize);
        }
        this.seed = seed;
        switch (log2m) {
            case 4: {
                this.alphaMM = 0.673 * (double)this.m * (double)this.m;
                break;
            }
            case 5: {
                this.alphaMM = 0.697 * (double)this.m * (double)this.m;
                break;
            }
            case 6: {
                this.alphaMM = 0.709 * (double)this.m * (double)this.m;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.m) * (double)this.m * (double)this.m;
            }
        }
    }

    public void clear(long seed) {
        this.clear();
        this.seed = seed;
    }

    public void clear() {
        for (LongArrayBitVector bv : this.bitVector) {
            bv.fill(false);
        }
    }

    private static final long jenkins(long x, long seed) {
        long a = seed + x;
        long b = seed;
        long c = -7046029254386353133L;
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public void add(int k, int v) {
        long x = IntHyperLogLogCounterArray.jenkins(v, this.seed);
        int j = (int)(x & (long)this.mMinus1);
        int r = Long.numberOfTrailingZeros(x >>> this.log2m | this.sentinelMask);
        LongBigList l = this.registers[k >>> this.counterShift];
        long offset = ((long)k << this.log2m) + (long)j & 0x3FFFFFFFL;
        l.set(offset, Math.max((long)(r + 1), l.getLong(offset)));
    }

    public LongBigList[] registers() {
        return this.registers;
    }

    protected double count(long[] bits, long offset) {
        int remaining = (int)(64L - offset % 64L);
        int word = (int)(offset / 64L);
        long curr = bits[word] >>> (int)(offset % 64L);
        int registerSize = this.registerSize;
        int mask = (1 << registerSize) - 1;
        double s = 0.0;
        int zeroes = 0;
        int j = this.m;
        while (j-- != 0) {
            long r;
            if (remaining >= registerSize) {
                r = curr & (long)mask;
                curr >>>= registerSize;
                remaining -= registerSize;
            } else {
                r = (curr | bits[++word] << remaining) & (long)mask;
                curr = bits[word] >>> registerSize - remaining;
                remaining += 64 - registerSize;
            }
            if (r == 0L) {
                ++zeroes;
            }
            s += 1.0 / (double)(1L << (int)r);
        }
        s = this.alphaMM / s;
        if (zeroes != 0 && s < 5.0 * (double)this.m / 2.0) {
            return (double)this.m * Math.log((double)this.m / (double)zeroes);
        }
        return s;
    }

    public double count(int k) {
        return this.count(this.bitVector[this.chunk(k)].bits(), this.offset(k));
    }
}

