/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.io;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.lang.MutableString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class OfflineIterableTest
extends TestCase {
    public void doIt(String[] strings) throws IOException {
        OfflineIterable.Serializer<MutableString, MutableString> stringSerializer = new OfflineIterable.Serializer<MutableString, MutableString>(){

            @Override
            public void read(DataInputStream dis, MutableString x) throws IOException {
                x.readSelfDelimUTF8(dis);
            }

            @Override
            public void write(MutableString x, DataOutputStream dos) throws IOException {
                x.writeSelfDelimUTF8(dos);
            }
        };
        OfflineIterable<MutableString, MutableString> stringIterable = new OfflineIterable<MutableString, MutableString>(stringSerializer, new MutableString());
        for (String s : strings) {
            stringIterable.add(new MutableString(s));
        }
        ObjectListIterator shouldBe = ObjectIterators.wrap((Object[])strings);
        for (MutableString m : stringIterable) {
            OfflineIterableTest.assertEquals((Object)new MutableString((String)shouldBe.next()), (Object)m);
        }
        OfflineIterableTest.assertFalse((boolean)shouldBe.hasNext());
        stringIterable.close();
        stringIterable.close();
    }

    public void testSimple() throws IOException {
        this.doIt(new String[]{"this", "is", "a", "test"});
    }

    public void testEmpty() throws IOException {
        this.doIt(new String[0]);
    }
}

