/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import junit.framework.TestCase;

public class PrefixFreeTransformationStrategyTest
extends TestCase {
    public void testGetBoolean() {
        LongArrayBitVector v = LongArrayBitVector.of(0, 1, 0);
        TransformationStrategy<LongArrayBitVector> prefixFree = TransformationStrategies.prefixFree();
        BitVector p = prefixFree.toBitVector(v);
        PrefixFreeTransformationStrategyTest.assertTrue((boolean)p.getBoolean(0));
        PrefixFreeTransformationStrategyTest.assertFalse((boolean)p.getBoolean(1));
        PrefixFreeTransformationStrategyTest.assertTrue((boolean)p.getBoolean(2));
        PrefixFreeTransformationStrategyTest.assertTrue((boolean)p.getBoolean(3));
        PrefixFreeTransformationStrategyTest.assertTrue((boolean)p.getBoolean(4));
        PrefixFreeTransformationStrategyTest.assertFalse((boolean)p.getBoolean(5));
        PrefixFreeTransformationStrategyTest.assertFalse((boolean)p.getBoolean(6));
        PrefixFreeTransformationStrategyTest.assertEquals((Object)LongArrayBitVector.of(1, 0, 1, 1, 1, 0, 0), (Object)p);
    }

    public void testGetLong() {
        LongArrayBitVector v = LongArrayBitVector.getInstance();
        v.append(0xFFFFFFFFL, 32);
        TransformationStrategy<LongArrayBitVector> prefixFree = TransformationStrategies.prefixFree();
        BitVector p = prefixFree.toBitVector(v);
        PrefixFreeTransformationStrategyTest.assertEquals((long)-1L, (long)p.getLong(0L, 64L));
        PrefixFreeTransformationStrategyTest.assertFalse((boolean)p.getBoolean(64));
        v.clear();
        v.append(0L, 32);
        PrefixFreeTransformationStrategyTest.assertEquals((long)0x5555555555555555L, (long)p.getLong(0L, 64L));
        PrefixFreeTransformationStrategyTest.assertFalse((boolean)p.getBoolean(64));
        v.clear();
        v.append(3L, 32);
        PrefixFreeTransformationStrategyTest.assertEquals((long)0x555555555555555FL, (long)p.getLong(0L, 64L));
        PrefixFreeTransformationStrategyTest.assertEquals((long)95L, (long)p.getLong(0L, 7L));
    }
}

