/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.OfflineIterable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public class BitVectorsTest
extends TestCase {
    public void testReadWriteFast() throws IOException {
        BitVector[] a;
        FastByteArrayOutputStream fbaos = new FastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)fbaos);
        LongArrayBitVector labv = LongArrayBitVector.getInstance();
        for (BitVector bv : a = new BitVector[]{BitVectors.ZERO, BitVectors.ONE, BitVectors.EMPTY_VECTOR, LongArrayBitVector.wrap(new long[]{-6148914691236517206L}, 64L), LongArrayBitVector.wrap(new long[]{0xAAAAAAAAAAAAAAAL}, 60L), LongArrayBitVector.wrap(new long[]{-6148914691236517206L, -6148914691236517206L}, 128L), LongArrayBitVector.wrap(new long[]{-6148914691236517206L, 0xAAAAAAAAAAAAAAAL}, 124L)}) {
            BitVectors.writeFast(bv, dos);
            dos.close();
            BitVectorsTest.assertEquals((Object)bv, (Object)BitVectors.readFast(new DataInputStream((InputStream)new FastByteArrayInputStream(fbaos.array))));
            fbaos.reset();
        }
        for (BitVector bv : a) {
            BitVectors.writeFast(bv, dos);
            dos.close();
            BitVectorsTest.assertEquals((Object)bv, (Object)BitVectors.readFast(new DataInputStream((InputStream)new FastByteArrayInputStream(fbaos.array)), labv));
            fbaos.reset();
        }
    }

    public void testMakeOffline() throws IOException {
        BitVector[] a = new BitVector[]{BitVectors.ZERO, BitVectors.ONE, BitVectors.EMPTY_VECTOR, LongArrayBitVector.wrap(new long[]{-6148914691236517206L}, 64L), LongArrayBitVector.wrap(new long[]{0xAAAAAAAAAAAAAAAL}, 60L), LongArrayBitVector.wrap(new long[]{-6148914691236517206L, -6148914691236517206L}, 128L), LongArrayBitVector.wrap(new long[]{-6148914691236517206L, 0xAAAAAAAAAAAAAAAL}, 124L)};
        OfflineIterable<BitVector, LongArrayBitVector> iterable = new OfflineIterable<BitVector, LongArrayBitVector>(BitVectors.OFFLINE_SERIALIZER, LongArrayBitVector.getInstance());
        iterable.addAll(Arrays.asList(a));
        OfflineIterable.OfflineIterator<BitVector, LongArrayBitVector> iterator = iterable.iterator();
        for (int i = 0; i < a.length; ++i) {
            BitVectorsTest.assertEquals((Object)a[i], iterator.next());
        }
        BitVectorsTest.assertFalse((boolean)iterator.hasNext());
    }
}

