/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi;

import it.unimi.dsi.Util;
import junit.framework.TestCase;

public class UtilTest
extends TestCase {
    public void testFormatBinarySize() {
        UtilTest.assertEquals((String)"1", (String)Util.formatBinarySize(1L));
        UtilTest.assertEquals((String)"2", (String)Util.formatBinarySize(2L));
        boolean ok = false;
        try {
            Util.formatBinarySize(6L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        UtilTest.assertTrue((boolean)ok);
        UtilTest.assertEquals((String)"128", (String)Util.formatBinarySize(128L));
        UtilTest.assertEquals((String)"1Ki", (String)Util.formatBinarySize(1024L));
        UtilTest.assertEquals((String)"2Ki", (String)Util.formatBinarySize(2048L));
        UtilTest.assertEquals((String)"1Mi", (String)Util.formatBinarySize(0x100000L));
        UtilTest.assertEquals((String)"2Mi", (String)Util.formatBinarySize(0x200000L));
        UtilTest.assertEquals((String)"1Gi", (String)Util.formatBinarySize(0x40000000L));
        UtilTest.assertEquals((String)"2Gi", (String)Util.formatBinarySize(0x80000000L));
        UtilTest.assertEquals((String)"1Ti", (String)Util.formatBinarySize(0x10000000000L));
        UtilTest.assertEquals((String)"2Ti", (String)Util.formatBinarySize(0x20000000000L));
    }

    public void testFormatSize() {
        UtilTest.assertEquals((String)"1", (String)Util.formatSize(1L));
        UtilTest.assertEquals((String)"2", (String)Util.formatSize(2L));
        UtilTest.assertEquals((String)"128", (String)Util.formatSize(128L));
        UtilTest.assertEquals((String)"1.00K", (String)Util.formatSize(1000L));
        UtilTest.assertEquals((String)"2.00K", (String)Util.formatSize(2000L));
        UtilTest.assertEquals((String)"2.50K", (String)Util.formatSize(2500L));
        UtilTest.assertEquals((String)"1.00M", (String)Util.formatSize(1000000L));
        UtilTest.assertEquals((String)"2.00M", (String)Util.formatSize(2000000L));
        UtilTest.assertEquals((String)"1.00G", (String)Util.formatSize(1000000000L));
        UtilTest.assertEquals((String)"2.00G", (String)Util.formatSize(2000000000L));
        UtilTest.assertEquals((String)"1.00T", (String)Util.formatSize(1000000000000L));
        UtilTest.assertEquals((String)"2.00T", (String)Util.formatSize(2000000000000L));
    }
}

