/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingOntologyConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLSettings;
import it.unibz.inf.ontop.injection.impl.OntopMappingOWLAPIConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyBuilders;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLSettingsImpl;
import it.unibz.inf.ontop.spec.OBDASpecification;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OntopSQLOWLAPIConfigurationImpl
extends OntopStandaloneSQLConfigurationImpl
implements OntopSQLOWLAPIConfiguration {
    private final OntopMappingOWLAPIConfigurationImpl mappingOWLConfiguration;

    OntopSQLOWLAPIConfigurationImpl(OntopStandaloneSQLSettings settings, OntopSQLOWLAPIOptions options) {
        super(settings, options.sqlOptions);
        this.mappingOWLConfiguration = new OntopMappingOWLAPIConfigurationImpl((OntopMappingSettings)settings, options.owlOptions);
    }

    public OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(() -> ((OntopMappingOWLAPIConfigurationImpl)this.mappingOWLConfiguration).loadOntology());
    }

    public Optional<OWLOntology> loadInputOntology() throws OWLOntologyCreationException {
        return this.mappingOWLConfiguration.loadInputOntology();
    }

    public static class BuilderImpl<B extends OntopSQLOWLAPIConfiguration.Builder<B>>
    extends OntopSQLOWLAPIBuilderMixin<B> {
        @Override
        public OntopSQLOWLAPIConfiguration build() {
            OntopStandaloneSQLSettingsImpl settings = new OntopStandaloneSQLSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopSQLOWLAPIOptions options = this.generateSQLOWLAPIOptions();
            return new OntopSQLOWLAPIConfigurationImpl((OntopStandaloneSQLSettings)settings, options);
        }
    }

    static abstract class OntopSQLOWLAPIBuilderMixin<B extends OntopSQLOWLAPIConfiguration.Builder<B>>
    extends OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLBuilderMixin<B>
    implements OntopSQLOWLAPIConfiguration.Builder<B> {
        private final OntopMappingOWLAPIConfigurationImpl.StandardMappingOWLAPIBuilderFragment<B> owlBuilderFragment;
        private final OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment<B> ontologyBuilderFragment;
        private boolean isOntologyDefined = false;

        OntopSQLOWLAPIBuilderMixin() {
            OntopSQLOWLAPIBuilderMixin builder = this;
            this.owlBuilderFragment = new OntopMappingOWLAPIConfigurationImpl.StandardMappingOWLAPIBuilderFragment((OntopMappingOWLAPIConfiguration.Builder)builder, this::declareOntologyDefined);
            this.ontologyBuilderFragment = new OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment((OntopMappingOntologyConfiguration.Builder)builder, this::declareOntologyDefined);
        }

        public B ontology(@Nonnull OWLOntology ontology) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.owlBuilderFragment.ontology(ontology));
        }

        public B ontologyFile(@Nonnull String urlOrPath) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(urlOrPath));
        }

        public B xmlCatalogFile(@Nonnull String xmlCatalogFile) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.xmlCatalogFile(xmlCatalogFile));
        }

        public B ontologyFile(@Nonnull URL url) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(url));
        }

        public B ontologyFile(@Nonnull File owlFile) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(owlFile));
        }

        void declareOntologyDefined() {
            if (this.isOntologyDefined) {
                throw new InvalidOntopConfigurationException("Ontology already defined!");
            }
            this.isOntologyDefined = true;
        }

        final OntopSQLOWLAPIOptions generateSQLOWLAPIOptions() {
            OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions standaloneSQLOptions = this.generateStandaloneSQLOptions();
            OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions = this.ontologyBuilderFragment.generateMappingOntologyOptions(standaloneSQLOptions.mappingOptions.mappingSQLOptions.mappingOptions);
            OntopMappingOWLAPIConfigurationImpl.OntopMappingOWLAPIOptions owlOptions = this.owlBuilderFragment.generateOntologyOWLAPIOptions(mappingOntologyOptions);
            return new OntopSQLOWLAPIOptions(standaloneSQLOptions, owlOptions);
        }
    }

    static class OntopSQLOWLAPIOptions {
        final OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions sqlOptions;
        final OntopMappingOWLAPIConfigurationImpl.OntopMappingOWLAPIOptions owlOptions;

        OntopSQLOWLAPIOptions(OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions sqlOptions, OntopMappingOWLAPIConfigurationImpl.OntopMappingOWLAPIOptions owlOptions) {
            this.sqlOptions = sqlOptions;
            this.owlOptions = owlOptions;
        }
    }
}

