/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.resultset.impl;

import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.impl.OntopConnectionCloseable;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLBooleanResultSet
implements BooleanResultSet {
    private final ResultSet set;
    private final QueryLogger queryLogger;
    private final OntopConnectionCloseable statementClosingCB;
    private boolean hasRead;

    public SQLBooleanResultSet(ResultSet set, QueryLogger queryLogger, OntopConnectionCloseable statementClosingCB) {
        this.set = set;
        this.queryLogger = queryLogger;
        this.statementClosingCB = statementClosingCB;
        this.hasRead = false;
    }

    public void close() throws OntopConnectionException {
        try {
            if (this.set != null) {
                this.set.close();
            }
            this.statementClosingCB.close();
        }
        catch (SQLException e) {
            this.queryLogger.declareConnectionException((Exception)e);
            throw new OntopConnectionException((Exception)e);
        }
    }

    public boolean getValue() throws OntopConnectionException {
        if (this.hasRead) {
            throw new IllegalStateException("getValue() can only called once!");
        }
        this.hasRead = true;
        this.queryLogger.declareLastResultRetrievedAndSerialize(1L);
        try {
            return this.set.next();
        }
        catch (SQLException e) {
            this.queryLogger.declareConnectionException((Exception)e);
            throw new OntopConnectionException((Exception)e);
        }
    }
}

